/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.filters;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.friendularity.jvision.broker.ImageStreamConsumer;
import org.friendularity.jvision.broker.ImageStreamImage;
import org.friendularity.jvision.broker.SimpleImageStreamProducer;
import org.friendularity.jvision.filters.BaseFilter;

public class FilterSequence
implements ListModel,
ImageStreamConsumer {
    private ArrayList<BaseFilter> filters = new ArrayList();
    private ArrayList<ListDataListener> listModelListeners = new ArrayList();
    private ImageStreamConsumer outputLocation = null;

    public void addOrReplaceByClass(BaseFilter f) {
        for (int i = this.filters.size() - 1; i >= 0; --i) {
            if (!f.getClass().isInstance(this.filters.get(i))) continue;
            this.filters.set(i, f);
            return;
        }
        this.filters.add(f);
        this.filterSequenceChanged();
    }

    public void removeByClass(BaseFilter f) {
        for (int i = this.filters.size() - 1; i >= 0; --i) {
            if (!f.getClass().isInstance(this.filters.get(i))) continue;
            this.filters.remove(i);
        }
        this.filterSequenceChanged();
    }

    public void move(int source, int target) {
        BaseFilter f = this.filters.get(source);
        this.filters.remove(source);
        this.filters.add(target, f);
        this.filterSequenceChanged();
    }

    public void add(BaseFilter f) {
        this.filters.add(f);
        this.filterSequenceChanged();
    }

    public void remove(int index) {
        this.filters.remove(index);
        this.filterSequenceChanged();
    }

    public String toString() {
        return "filter_sequence";
    }

    @Override
    public int getSize() {
        return this.filters.size();
    }

    public Object getElementAt(int index) {
        return this.filters.get(index).toString();
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listModelListeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listModelListeners.remove(l);
    }

    private void filterSequenceChanged() {
        ListDataEvent lde = new ListDataEvent(this, 0, 0, this.filters.size() - 1);
        Iterator<ListDataListener> i = this.listModelListeners.iterator();
        while (i.hasNext()) {
            i.next().contentsChanged(lde);
        }
        this.rewireImageChain();
    }

    public void showParamUIForIndex(int i) {
        this.filters.get(i).showParamUI(null);
    }

    public String serializeIndex(int i) {
        return this.filters.get(i).serialize();
    }

    @Override
    public void setConsumedImage(ImageStreamImage img) {
        if (this.filters.isEmpty()) {
            this.outputLocation.setConsumedImage(img);
        } else {
            this.filters.get(0).setConsumedImage(img);
        }
    }

    @Override
    public void setConsumedMessage(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void sourceIsEnding() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void sendOutputTo(SimpleImageStreamProducer outputProducer) {
        this.outputLocation = outputProducer;
    }

    private void rewireImageChain() {
        Iterator<BaseFilter> i = this.filters.iterator();
        while (i.hasNext()) {
            i.next().removeAllConsumers();
        }
        for (int i2 = 0; i2 < this.filters.size() - 1; ++i2) {
            this.filters.get(i2).addConsumer(this.filters.get(i2 + 1));
        }
        this.filters.get(this.filters.size() - 1).addConsumer(this.outputLocation);
    }
}

