/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.friendularity.jvision.broker.ImageStreamBroker;
import org.friendularity.jvision.engine.CVChainManager;
import org.friendularity.jvision.gui.FilterBox;

class CVChainInfoDialog
extends JDialog
implements DocumentListener,
ChangeListener,
ListSelectionListener {
    private JTextField nameField;
    private JCheckBox intermediatesVisible;
    private JList sources;
    private JButton ok;
    private FilterBox fb;
    private CVChainManager cvccm;
    private static int nextChainNum = 0;

    public CVChainInfoDialog(FilterBox fb, CVChainManager cvccm) {
        super(fb.getFrame(), "CVChainInfo", true);
        this.fb = fb;
        this.cvccm = cvccm;
        this.setDefaultCloseOperation(2);
        JComponent cp = (JComponent)this.getContentPane();
        cp.setLayout(new BoxLayout(cp, 1));
        cp.add(new JLabel("ImageStream name prefix"));
        this.nameField = new JTextField("chain" + nextChainNum++);
        cp.add(this.nameField);
        this.nameField.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        this.nameField.getDocument().addDocumentListener(this);
        this.intermediatesVisible = new JCheckBox("publish intermediate steps");
        cp.add(this.intermediatesVisible);
        this.intermediatesVisible.addChangeListener(this);
        cp.add(new JLabel("Feed CVChain from this source"));
        this.sources = new JList(){

            @Override
            protected void paintBorder(Graphics g) {
                g.setColor(Color.black);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        };
        DefaultListModel<String> lm = new DefaultListModel<String>();
        this.sources.setModel(lm);
        cp.add(this.sources);
        int item_index = 0;
        Iterator<String> names = ImageStreamBroker.getDefaultImageStreamBroker().imageStreamNames();
        while (names.hasNext()) {
            lm.add(item_index++, names.next());
        }
        if (item_index > 0) {
            this.sources.setSelectedIndex(0);
        }
        this.sources.addListSelectionListener(this);
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 0));
        this.ok = new JButton("OK");
        this.ok.setDefaultCapable(true);
        this.ok.setEnabled(false);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CVChainInfoDialog.this.buildCVChain();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.setDefaultCapable(false);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CVChainInfoDialog.this.dispose();
            }
        });
        pnl.add(this.ok);
        pnl.add(cancel);
        cp.add(pnl);
        this.setSize(new Dimension(400, 400));
        this.updateOKToOK();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateOKToOK();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateOKToOK();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateOKToOK();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateOKToOK();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateOKToOK();
    }

    private void updateOKToOK() {
        String name = this.nameField.getText().trim();
        this.ok.setEnabled(name.length() > 0 && !name.equals("name here") && this.sources.getSelectedIndex() != -1);
        if (!ImageStreamBroker.getDefaultImageStreamBroker().imageStreamPrefixOK(name)) {
            this.ok.setEnabled(false);
        }
        if (CVChainManager.getDefaultManager().chainExists(name)) {
            this.ok.setEnabled(false);
        }
    }

    private void buildCVChain() {
        System.out.println("OK fired");
        this.cvccm.buildChain(this.fb, this.nameField.getText().trim(), this.intermediatesVisible.getModel().isSelected(), (String)this.sources.getModel().getElementAt(this.sources.getSelectedIndex()));
        this.setVisible(false);
    }
}

