/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.engine;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.friendularity.jvision.engine.CVChain;
import org.friendularity.jvision.gui.CVChainControl;
import org.friendularity.jvision.gui.FilterBox;

public class CVChainManager {
    private static CVChainManager defaultCVManager = null;
    private HashMap<String, CVChain> cvChains = new HashMap();

    public static CVChainManager getDefaultManager() {
        if (defaultCVManager == null) {
            defaultCVManager = new CVChainManager();
        }
        return defaultCVManager;
    }

    private CVChainManager() {
    }

    public boolean chainExists(String name) {
        return this.cvChains.containsKey(name);
    }

    public void buildChain(FilterBox fb, String name, boolean intermediatesVisible, String source) {
        if (this.chainExists(name)) {
            throw new IllegalArgumentException("Chain " + name + " already exists");
        }
        CVChain cvchain = new CVChain(name, intermediatesVisible, source);
        this.cvChains.put(name, cvchain);
        CVChainControl cvc = new CVChainControl(cvchain, fb);
        fb.addCVChainControl(cvc);
    }

    public void buildChain(FilterBox fb, Resource cvchainRDF, Model M) {
        CVChain cvchain = new CVChain(M, cvchainRDF);
        this.cvChains.put(cvchain.getName(), cvchain);
        CVChainControl cvc = new CVChainControl(cvchain, fb);
        fb.addCVChainControl(cvc);
    }

    public void remove(FilterBox fb, CVChainControl cvcc) {
        if (fb == null || cvcc == null) {
            Logger.getLogger(CVChainManager.class.getName()).log(Level.SEVERE, "evil thing in remove in CVChainManager");
        }
        fb.removeChainControl(cvcc);
        CVChain cvc = this.cvChains.get(cvcc.getName());
        cvc.unwire();
        this.cvChains.remove(cvcc.getName());
    }
}

