/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.engine;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.appdapter.core.log.BasicDebugger;
import org.friendularity.jvision.broker.ImageStreamBroker;
import org.friendularity.jvision.broker.ImageStreamImage;
import org.friendularity.jvision.broker.SimpleImageStreamProducer;
import org.friendularity.jvision.engine.Quitter;
import org.friendularity.jvision.gui.FileLocations;
import org.opencv.core.Mat;
import org.opencv.highgui.Highgui;
import org.opencv.highgui.VideoCapture;
import org.opencv.imgproc.Imgproc;

public class JVisionEngine
extends BasicDebugger
implements Runnable {
    public static final String CAMERA_NAME = "jvision.camera";
    private static JVisionEngine sDefaultJVisionEngine = null;
    private VideoCapture myVidCapture;
    private Mat myCameraImage_Mat;
    private SimpleImageStreamProducer myCameraISP = new SimpleImageStreamProducer("jvision.camera");
    private final Object cameraToken = new Object();
    private Quitter myQuitter;

    public static JVisionEngine getDefaultJVisionEngine() {
        if (sDefaultJVisionEngine == null) {
            sDefaultJVisionEngine = new JVisionEngine();
        }
        return sDefaultJVisionEngine;
    }

    private JVisionEngine() {
        ImageStreamBroker.getDefaultImageStreamBroker().addImageStreamProducer(this.myCameraISP);
    }

    public void setQuitter(Quitter q) {
        this.myQuitter = q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeCamera(int camera) {
        this.getLogger().info("Changing vidCapture stream to " + camera);
        Object object = this.cameraToken;
        synchronized (object) {
            this.myVidCapture.release();
            this.myVidCapture = new VideoCapture();
            if (!this.myVidCapture.open(camera)) {
                this.getLogger().error("Failed to open vidCapture stream");
                this.myVidCapture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        boolean connectedFlag = false;
        try {
            this.getLogger().info("opening native library often takes 5-10 seconds");
            this.getLogger().info("Opening native library handle for OpenCV 2.4.6.0");
            System.loadLibrary("opencv_java246");
            Object object = this.cameraToken;
            synchronized (object) {
                this.myVidCapture = new VideoCapture();
                this.getLogger().info("Opening vidCapture stream");
                if (!this.myVidCapture.open(0)) {
                    this.getLogger().error("Failed to open vidCapture stream");
                    this.myVidCapture = null;
                    return false;
                }
            }
            this.myCameraImage_Mat = new Mat();
            connectedFlag = true;
        }
        catch (Throwable t) {
            this.getLogger().error("Problem connecting JVisionEngine: ", t);
        }
        return connectedFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processOneFrame() {
        VideoCapture vc = this.myVidCapture;
        Object object = this.cameraToken;
        synchronized (object) {
            if (!vc.read(this.myCameraImage_Mat)) {
                this.getLogger().error("Oops bad read");
            }
        }
        this.myCameraISP.setConsumedImage(new ImageStreamImage(this.myCameraImage_Mat));
        Thread.yield();
    }

    public static BufferedImage matToBufferedImage(Mat bgr) {
        BufferedImage image;
        int width = bgr.width();
        int height = bgr.height();
        if (bgr.channels() == 1) {
            image = new BufferedImage(width, height, 10);
            WritableRaster raster = image.getRaster();
            byte[] b = new byte[width * height];
            bgr.get(0, 0, b);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    raster.setSample(x, y, 0, b[x + y * width]);
                }
            }
        } else {
            int channels = bgr.channels();
            if (channels != 3) {
                throw new IllegalArgumentException("We only handle 3 channel images now");
            }
            image = new BufferedImage(width, height, 1);
            WritableRaster raster = image.getRaster();
            byte[] b = new byte[width * height * channels];
            bgr.get(0, 0, b);
            int[] rgb = new int[3];
            for (int y = 0; y < height; ++y) {
                int base = y * width * channels;
                for (int x = 0; x < width; ++x) {
                    rgb[0] = b[base + 3 * x + 2];
                    rgb[1] = b[base + 3 * x + 1];
                    rgb[2] = b[base + 3 * x];
                    raster.setPixel(x, y, rgb);
                }
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.myQuitter != null) {
            int MAX_ERRORS_ALLOWED = 100;
            int errorCount = 0;
            int framesProcessedCount = 0;
            this.getLogger().info("JVision Engine beginning frame processing loop");
            while (!this.myQuitter.wantsToQuit()) {
                try {
                    this.processOneFrame();
                    if (++framesProcessedCount % 1000 != 0) continue;
                    this.getLogger().info("JVision system has now processed {} frames, and caught {} errors.", (Object)framesProcessedCount, (Object)errorCount);
                }
                catch (Throwable t) {
                    this.getLogger().error("Exception # " + ++errorCount + " (out of " + MAX_ERRORS_ALLOWED + " allowed) caught during processOneFrame", t);
                    if (t instanceof InterruptedException) {
                        this.getLogger().warn("JVision run() got InterruptedException, run loop will quit.");
                        this.myQuitter.setWantsToQuit(true);
                    }
                    if (errorCount < MAX_ERRORS_ALLOWED) continue;
                    this.getLogger().warn("JVision run() error count is now {}, run loop will quit.", (Object)errorCount);
                    this.myQuitter.setWantsToQuit(true);
                }
            }
            this.getLogger().info("Quitter asked us to end the processing loop");
        } else {
            this.getLogger().warn("I don't have a quitter set, so I'm not going to run!");
        }
        this.getLogger().info("Releasing vidCapture");
        Object object = this.cameraToken;
        synchronized (object) {
            this.myVidCapture.release();
        }
        this.getLogger().info("run() complete, notifying quitter we're done");
        this.myQuitter.notifyQuitCompleted();
    }

    public void testWithSomeDuckFiles() {
        Mat image = Highgui.imread(FileLocations.imageBase() + "duck.jpg", 1);
        Mat grayimage = new Mat();
        Imgproc.cvtColor(image, grayimage, 7);
        Highgui.imwrite(FileLocations.imageBase() + "grayduck.png", grayimage);
        Mat someimage = new Mat();
        image.convertTo(someimage, 0, 0.5);
        Highgui.imwrite(FileLocations.imageBase() + "outduck.png", someimage);
    }

    public void requestQuit() {
        this.myQuitter.setWantsToQuit(true);
    }
}

