/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.filters;

import java.util.ArrayList;
import javax.swing.JFrame;
import org.friendularity.jvision.filters.ApplicativeBaseFilter;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

public class Contour
extends ApplicativeBaseFilter {
    @Override
    public void apply(Mat in, Mat out) {
        try {
            ArrayList<MatOfPoint> contours = new ArrayList<MatOfPoint>();
            Mat hierarchy = new Mat();
            Imgproc.findContours(in, contours, hierarchy, 0, 4);
            in.clone().copyTo(out);
            Scalar color = new Scalar(0.0, 0.0, 255.0);
            for (MatOfPoint pts : contours) {
                for (int r = 0; r < pts.rows(); ++r) {
                    for (int c = 0; c < pts.cols() - 1; ++c) {
                        Core.line(out, new Point(pts.get(r, c)[0], pts.get(r, c)[1]), new Point(pts.get(r, c + 1)[0], pts.get(r, c + 1)[1]), color);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            in.clone().copyTo(out);
        }
    }

    public String toString() {
        return "contour";
    }

    @Override
    public void showParamUI(JFrame parent) {
    }

    @Override
    public String serialize() {
        return "";
    }

    @Override
    public void deserialize(String str) {
    }
}

