/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.filters;

import javax.swing.JFrame;
import org.friendularity.jvision.filters.ApplicativeBaseFilter;
import org.friendularity.jvision.filters.FilterParams;
import org.friendularity.jvision.filters.ParamChangedListener;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class Dilate
extends ApplicativeBaseFilter
implements ParamChangedListener {
    private Size kernal_size = new Size(13.0, 13.0);
    private int dilateIterations = 13;

    @Override
    public void apply(Mat in, Mat out) {
        Mat kernal = Imgproc.getStructuringElement(2, this.kernal_size);
        Imgproc.dilate(in, out, kernal);
    }

    public String toString() {
        return "dilate";
    }

    @Override
    public void showParamUI(JFrame parent) {
        FilterParams.showParamWidget(this, "dilation iterations,slider,1," + this.dilateIterations + ",24");
    }

    @Override
    public String serialize() {
        return Integer.toString(this.dilateIterations);
    }

    @Override
    public void deserialize(String str) {
        this.dilateIterations = (int)Double.parseDouble(str);
        this.kernal_size = new Size(this.dilateIterations, this.dilateIterations);
    }

    @Override
    public void paramChanged(int index, String param) {
        this.dilateIterations = (int)Double.parseDouble(param);
        if (this.dilateIterations < 1) {
            this.dilateIterations = 1;
        }
        this.kernal_size = new Size(this.dilateIterations, this.dilateIterations);
    }
}

