/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.filters;

import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.friendularity.jvision.filters.BananaDetector;
import org.friendularity.jvision.filters.BaseFilter;
import org.friendularity.jvision.filters.ColorThreshold;
import org.friendularity.jvision.filters.Contour;
import org.friendularity.jvision.filters.Dilate;
import org.friendularity.jvision.filters.Erode;
import org.friendularity.jvision.filters.FaceDetector;
import org.friendularity.jvision.filters.Farneback;
import org.friendularity.jvision.filters.FarnebackBGx;
import org.friendularity.jvision.filters.FilterInfo;
import org.friendularity.jvision.filters.GlassesDetector;
import org.friendularity.jvision.filters.Grayscale;
import org.friendularity.jvision.filters.HSVtoBGR;
import org.friendularity.jvision.filters.HalfSize;
import org.friendularity.jvision.filters.ProfileDetector;
import org.friendularity.jvision.filters.QuarterSize;
import org.friendularity.jvision.filters.RGBtoHSV;

public class FilterInfoManager {
    private static final TreeMap<String, FilterInfo> filterTypes = new TreeMap();
    private static final FilterInfo[] filterProtos = new FilterInfo[]{new FilterInfo(){

        @Override
        public String toString() {
            return "banana detector";
        }

        @Override
        public BaseFilter createInstance() {
            return new BananaDetector();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "Detector"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "face detector";
        }

        @Override
        public BaseFilter createInstance() {
            return new FaceDetector();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "Detector"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "glasses detector";
        }

        @Override
        public BaseFilter createInstance() {
            return new GlassesDetector();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "Detector"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "profile detector";
        }

        @Override
        public BaseFilter createInstance() {
            return new ProfileDetector();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "Detector"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "halfsize";
        }

        @Override
        public BaseFilter createInstance() {
            return new HalfSize();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "ImageProc"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "quartersize";
        }

        @Override
        public BaseFilter createInstance() {
            return new QuarterSize();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "ImageProc"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "color threshold";
        }

        @Override
        public BaseFilter createInstance() {
            return new ColorThreshold();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "ImageProc"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "grey";
        }

        @Override
        public BaseFilter createInstance() {
            return new Grayscale();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "ImageProc"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "BGR to HSV";
        }

        @Override
        public BaseFilter createInstance() {
            return new RGBtoHSV();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "ImageProc"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "HSV to BGR";
        }

        @Override
        public BaseFilter createInstance() {
            return new HSVtoBGR();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "ImageProc"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "contour display";
        }

        @Override
        public BaseFilter createInstance() {
            return new Contour();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "Line Operations"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "dilate";
        }

        @Override
        public BaseFilter createInstance() {
            return new Dilate();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "Morphology"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "erode";
        }

        @Override
        public BaseFilter createInstance() {
            return new Erode();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "Morphology"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "Farneback optical flow visual";
        }

        @Override
        public BaseFilter createInstance() {
            return new Farneback();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "Motion"};
            return c;
        }
    }, new FilterInfo(){

        @Override
        public String toString() {
            return "Farneback optical flow BGx";
        }

        @Override
        public BaseFilter createInstance() {
            return new FarnebackBGx();
        }

        @Override
        public String[] getCategory() {
            String[] c = new String[]{"CV", "Motion"};
            return c;
        }
    }};

    public static FilterInfo getFilterInfo(String type) {
        return filterTypes.get(type);
    }

    public static void addAllFilterInfoToTree(DefaultMutableTreeNode top) {
        Object category = null;
        Object filter = null;
        for (int i = 0; i < filterProtos.length; ++i) {
            FilterInfoManager.addAFilter(top, 0, filterProtos[i].getCategory(), filterProtos[i]);
        }
    }

    private static void addAFilter(TreeNode node, int index, String[] category, FilterInfo filterInfo) {
        if (index >= category.length) {
            ((DefaultMutableTreeNode)node).add(new DefaultMutableTreeNode(filterInfo, false));
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (!node.getChildAt(i).toString().equals(category[index])) continue;
                FilterInfoManager.addAFilter(node.getChildAt(i), index + 1, category, filterInfo);
                return;
            }
            DefaultMutableTreeNode newnode = new DefaultMutableTreeNode(category[index]);
            ((DefaultMutableTreeNode)node).add(newnode);
            FilterInfoManager.addAFilter(newnode, index + 1, category, filterInfo);
        }
    }

    static {
        for (int i = 0; i < filterProtos.length; ++i) {
            filterTypes.put(filterProtos[i].toString(), filterProtos[i]);
        }
    }
}

