/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.calib3d;

import org.opencv.core.Mat;

public class StereoSGBM {
    protected final long nativeObj;
    public static final int DISP_SHIFT = 4;
    public static final int DISP_SCALE = 16;

    protected StereoSGBM(long addr) {
        this.nativeObj = addr;
    }

    public StereoSGBM() {
        this.nativeObj = StereoSGBM.StereoSGBM_0();
    }

    public StereoSGBM(int minDisparity, int numDisparities, int SADWindowSize, int P1, int P2, int disp12MaxDiff, int preFilterCap, int uniquenessRatio, int speckleWindowSize, int speckleRange, boolean fullDP) {
        this.nativeObj = StereoSGBM.StereoSGBM_1(minDisparity, numDisparities, SADWindowSize, P1, P2, disp12MaxDiff, preFilterCap, uniquenessRatio, speckleWindowSize, speckleRange, fullDP);
    }

    public StereoSGBM(int minDisparity, int numDisparities, int SADWindowSize) {
        this.nativeObj = StereoSGBM.StereoSGBM_2(minDisparity, numDisparities, SADWindowSize);
    }

    public void compute(Mat left, Mat right, Mat disp) {
        StereoSGBM.compute_0(this.nativeObj, left.nativeObj, right.nativeObj, disp.nativeObj);
    }

    public int get_minDisparity() {
        int retVal = StereoSGBM.get_minDisparity_0(this.nativeObj);
        return retVal;
    }

    public void set_minDisparity(int minDisparity) {
        StereoSGBM.set_minDisparity_0(this.nativeObj, minDisparity);
    }

    public int get_numberOfDisparities() {
        int retVal = StereoSGBM.get_numberOfDisparities_0(this.nativeObj);
        return retVal;
    }

    public void set_numberOfDisparities(int numberOfDisparities) {
        StereoSGBM.set_numberOfDisparities_0(this.nativeObj, numberOfDisparities);
    }

    public int get_SADWindowSize() {
        int retVal = StereoSGBM.get_SADWindowSize_0(this.nativeObj);
        return retVal;
    }

    public void set_SADWindowSize(int SADWindowSize) {
        StereoSGBM.set_SADWindowSize_0(this.nativeObj, SADWindowSize);
    }

    public int get_preFilterCap() {
        int retVal = StereoSGBM.get_preFilterCap_0(this.nativeObj);
        return retVal;
    }

    public void set_preFilterCap(int preFilterCap) {
        StereoSGBM.set_preFilterCap_0(this.nativeObj, preFilterCap);
    }

    public int get_uniquenessRatio() {
        int retVal = StereoSGBM.get_uniquenessRatio_0(this.nativeObj);
        return retVal;
    }

    public void set_uniquenessRatio(int uniquenessRatio) {
        StereoSGBM.set_uniquenessRatio_0(this.nativeObj, uniquenessRatio);
    }

    public int get_P1() {
        int retVal = StereoSGBM.get_P1_0(this.nativeObj);
        return retVal;
    }

    public void set_P1(int P1) {
        StereoSGBM.set_P1_0(this.nativeObj, P1);
    }

    public int get_P2() {
        int retVal = StereoSGBM.get_P2_0(this.nativeObj);
        return retVal;
    }

    public void set_P2(int P2) {
        StereoSGBM.set_P2_0(this.nativeObj, P2);
    }

    public int get_speckleWindowSize() {
        int retVal = StereoSGBM.get_speckleWindowSize_0(this.nativeObj);
        return retVal;
    }

    public void set_speckleWindowSize(int speckleWindowSize) {
        StereoSGBM.set_speckleWindowSize_0(this.nativeObj, speckleWindowSize);
    }

    public int get_speckleRange() {
        int retVal = StereoSGBM.get_speckleRange_0(this.nativeObj);
        return retVal;
    }

    public void set_speckleRange(int speckleRange) {
        StereoSGBM.set_speckleRange_0(this.nativeObj, speckleRange);
    }

    public int get_disp12MaxDiff() {
        int retVal = StereoSGBM.get_disp12MaxDiff_0(this.nativeObj);
        return retVal;
    }

    public void set_disp12MaxDiff(int disp12MaxDiff) {
        StereoSGBM.set_disp12MaxDiff_0(this.nativeObj, disp12MaxDiff);
    }

    public boolean get_fullDP() {
        boolean retVal = StereoSGBM.get_fullDP_0(this.nativeObj);
        return retVal;
    }

    public void set_fullDP(boolean fullDP) {
        StereoSGBM.set_fullDP_0(this.nativeObj, fullDP);
    }

    protected void finalize() throws Throwable {
        StereoSGBM.delete(this.nativeObj);
    }

    private static native long StereoSGBM_0();

    private static native long StereoSGBM_1(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, boolean var10);

    private static native long StereoSGBM_2(int var0, int var1, int var2);

    private static native void compute_0(long var0, long var2, long var4, long var6);

    private static native int get_minDisparity_0(long var0);

    private static native void set_minDisparity_0(long var0, int var2);

    private static native int get_numberOfDisparities_0(long var0);

    private static native void set_numberOfDisparities_0(long var0, int var2);

    private static native int get_SADWindowSize_0(long var0);

    private static native void set_SADWindowSize_0(long var0, int var2);

    private static native int get_preFilterCap_0(long var0);

    private static native void set_preFilterCap_0(long var0, int var2);

    private static native int get_uniquenessRatio_0(long var0);

    private static native void set_uniquenessRatio_0(long var0, int var2);

    private static native int get_P1_0(long var0);

    private static native void set_P1_0(long var0, int var2);

    private static native int get_P2_0(long var0);

    private static native void set_P2_0(long var0, int var2);

    private static native int get_speckleWindowSize_0(long var0);

    private static native void set_speckleWindowSize_0(long var0, int var2);

    private static native int get_speckleRange_0(long var0);

    private static native void set_speckleRange_0(long var0, int var2);

    private static native int get_disp12MaxDiff_0(long var0);

    private static native void set_disp12MaxDiff_0(long var0, int var2);

    private static native boolean get_fullDP_0(long var0);

    private static native void set_fullDP_0(long var0, boolean var2);

    private static native void delete(long var0);
}

