/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.filters;

import javax.swing.JFrame;
import org.friendularity.jvision.filters.ApplicativeBaseFilter;
import org.friendularity.jvision.filters.FilterParams;
import org.friendularity.jvision.filters.ParamChangedListener;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;

public class ColorThreshold
extends ApplicativeBaseFilter
implements ParamChangedListener {
    public static final int MIN_H = 0;
    public static final int MIN_S = 1;
    public static final int MIN_V = 2;
    public static final int MAX_H = 3;
    public static final int MAX_S = 4;
    public static final int MAX_V = 5;
    private float[] params = new float[]{0.0f, 0.0f, 0.0f, 255.0f, 255.0f, 255.0f};

    @Override
    public void apply(Mat in, Mat out) {
        Mat hsv = new Mat();
        Imgproc.cvtColor(in, hsv, 40);
        Core.inRange(hsv, new Scalar(this.params[0], this.params[1], this.params[2]), new Scalar(this.params[3], this.params[4], this.params[5]), out);
    }

    public String toString() {
        return "color_threshold";
    }

    @Override
    public void showParamUI(JFrame parent) {
        FilterParams.showParamWidget(this, "min H or B,slider,0," + this.params[0] + ",256," + "min S or G,slider,0," + this.params[1] + ",256," + "min V or R,slider,0," + this.params[2] + ",256," + "max H or B,slider,0," + this.params[3] + ",256," + "max S or G,slider,0," + this.params[4] + ",256," + "max V or R,slider,0," + this.params[5] + ",256");
    }

    @Override
    public String serialize() {
        return "" + this.params[0] + "," + this.params[1] + "," + this.params[2] + "," + this.params[3] + "," + this.params[4] + "," + this.params[5];
    }

    @Override
    public void deserialize(String str) {
        String[] s = str.split(",");
        for (int i = 0; i < 6; ++i) {
            this.params[i] = Float.parseFloat(s[i]);
        }
    }

    @Override
    public void paramChanged(int index, String param) {
        this.params[index] = Float.parseFloat(param);
    }
}

