/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.filters;

import javax.swing.JFrame;
import org.friendularity.jvision.filters.ApplicativeBaseFilter;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import org.opencv.video.Video;

public class Farneback
extends ApplicativeBaseFilter {
    Mat mLastFrame = null;
    Mat mFlowImage = null;

    @Override
    public void apply(Mat in, Mat out) {
        if (this.mFlowImage == null) {
            this.mFlowImage = new Mat(in.width(), in.height(), CvType.CV_32FC2);
        }
        Mat gray = new Mat();
        if (in.channels() > 1) {
            Imgproc.cvtColor(in, gray, 7);
        } else {
            in.copyTo(gray);
        }
        if (this.mLastFrame == null) {
            this.mLastFrame = new Mat();
            Imgproc.cvtColor(in, this.mLastFrame, 7);
            in.copyTo(out);
            return;
        }
        Video.calcOpticalFlowFarneback(this.mLastFrame, gray, this.mFlowImage, 0.5, 3, 15, 3, 5, 1.2, 0);
        in.copyTo(out);
        Farneback.drawOptFlowMap(this.mFlowImage, out);
        gray.copyTo(this.mLastFrame);
    }

    static void drawOptFlowMap(Mat flow, Mat cflowmap) {
        int h = cflowmap.height();
        int w = cflowmap.width();
        float[] fbuf = new float[2];
        float scale = 1.0f;
        float total_x = 0.0f;
        float total_y = 0.0f;
        for (int y = 0; y < h; y += 16) {
            for (int x = 0; x < w; x += 16) {
                flow.get(x, y, fbuf);
                Point fp = new Point(fbuf[0], fbuf[1]);
                total_x = (float)((double)total_x + fp.x);
                total_y = (float)((double)total_y + fp.y);
                Core.line(cflowmap, new Point(x, y), new Point((int)((double)x + (double)scale * fp.x), (int)((double)y + (double)scale * fp.y)), new Scalar(128.0, 255.0, 128.0));
                Core.circle(cflowmap, new Point(x, y), 2, new Scalar(128.0, 128.0, 128.0), -1);
            }
        }
        total_x = total_x / (float)h / (float)w * 256.0f;
        total_y = total_y / (float)h / (float)w * 256.0f;
        Core.line(cflowmap, new Point((double)w / 2.0, (double)h / 2.0), new Point((int)((double)w / 2.0 + (double)(10.0f * scale * total_x)), (int)((double)h / 2.0 + (double)(10.0f * scale * total_y))), new Scalar(0.0, 255.0, 255.0), 4);
    }

    public String toString() {
        return "farneback_optical_flow";
    }

    @Override
    public void showParamUI(JFrame parent) {
    }

    @Override
    public String serialize() {
        return "";
    }

    @Override
    public void deserialize(String str) {
    }
}

