/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.friendularity.jvision.filters.BaseFilter;
import org.friendularity.jvision.filters.FilterSequence;

public class FilterList
extends JList
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    static DataFlavor localObjectFlavor;
    static DataFlavor[] supportedFlavors;
    DragSource dragSource;
    DropTarget dropTarget;
    Object dropTargetCell;
    int draggedIndex = -1;

    public FilterList() {
        this.setCellRenderer(new ReorderableListCellRenderer());
        this.setModel(new DefaultListModel());
        this.dragSource = new DragSource();
        DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.dropTarget = new DropTarget(this, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        System.out.println("dragGestureRecognized");
        Point clickPoint = dge.getDragOrigin();
        int index = this.locationToIndex(clickPoint);
        if (index == -1) {
            return;
        }
        Object target = this.getModel().getElementAt(index);
        RJLTransferable trans = new RJLTransferable(target);
        this.draggedIndex = index;
        this.dragSource.startDrag(dge, Cursor.getDefaultCursor(), trans, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        System.out.println("dragDropEnd()");
        this.dropTargetCell = null;
        this.draggedIndex = -1;
        this.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        System.out.println("dragEnter");
        if (dtde.getSource() != this.dropTarget) {
            System.out.println("not self, rejecting dragEnter");
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(3);
            System.out.println("accepted dragEnter");
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (dtde.getSource() != this.dropTarget) {
            System.out.println("not self, rejecting dragOver");
            dtde.rejectDrag();
            return;
        }
        Point dragPoint = dtde.getLocation();
        int index = this.locationToIndex(dragPoint);
        this.dropTargetCell = index == -1 ? null : this.getModel().getElementAt(index);
        this.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        System.out.println("drop()!");
        if (!dtde.isDataFlavorSupported(localObjectFlavor)) {
            System.out.println("rejecting because cannot get localObjectFlavor (" + dtde.getSource().getClass().getName() + ")");
            dtde.rejectDrop();
            return;
        }
        Point dropPoint = dtde.getLocation();
        int index = this.locationToIndex(dropPoint);
        System.out.println("drop index is " + index);
        if (dtde.getSource() != this.dropTarget) {
            System.out.println("foreign drop from (" + dtde.getSource().getClass().getName() + ")");
            dtde.acceptDrop(1);
            FilterSequence mod = (FilterSequence)this.getModel();
            try {
                mod.addOrReplaceByClass((BaseFilter)dtde.getTransferable().getTransferData(localObjectFlavor));
            }
            catch (UnsupportedFlavorException ex) {
                Logger.getLogger(FilterList.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(FilterList.class.getName()).log(Level.SEVERE, null, ex);
            }
            return;
        }
        boolean dropped = false;
        try {
            if (index == -1) {
                System.out.println("dropped onto -1");
                dtde.rejectDrop();
                return;
            }
            if (index == this.draggedIndex) {
                System.out.println("dropped onto self");
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(2);
            System.out.println("accepted");
            Object dragged = dtde.getTransferable().getTransferData(localObjectFlavor);
            System.out.println("drop " + this.draggedIndex + " to " + index);
            boolean sourceBeforeTarget = this.draggedIndex < index;
            System.out.println("source is" + (sourceBeforeTarget ? "" : " not") + " before target");
            System.out.println("insert at " + (sourceBeforeTarget ? index - 1 : index));
            FilterSequence mod = (FilterSequence)this.getModel();
            mod.move(this.draggedIndex, sourceBeforeTarget ? index - 1 : index);
            dropped = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dtde.dropComplete(dropped);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public static void showReorderableFilterList(ListModel defModel) {
        FilterList list = new FilterList();
        list.setModel(defModel);
        JScrollPane scroller = new JScrollPane(list, 22, 31);
        JFrame frame = new JFrame("Drag to reorder filters");
        frame.getContentPane().add(scroller);
        frame.pack();
        frame.setVisible(true);
    }

    static {
        try {
            localObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        supportedFlavors = new DataFlavor[]{localObjectFlavor};
    }

    class ReorderableListCellRenderer
    extends DefaultListCellRenderer {
        boolean isTargetCell;
        boolean isLastItem;
        Insets normalInsets = super.getInsets();
        Insets lastItemInsets;
        int BOTTOM_PAD = 30;

        public ReorderableListCellRenderer() {
            this.lastItemInsets = new Insets(this.normalInsets.top, this.normalInsets.left, this.normalInsets.bottom + this.BOTTOM_PAD, this.normalInsets.right);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.isTargetCell = value == FilterList.this.dropTargetCell;
            this.isLastItem = index == list.getModel().getSize() - 1;
            boolean showSelected = isSelected & FilterList.this.dropTargetCell == null;
            return super.getListCellRendererComponent((JList<?>)list, value, index, showSelected, hasFocus);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isTargetCell) {
                g.setColor(Color.black);
                g.drawLine(0, 0, this.getSize().width, 0);
            }
        }
    }

    class RJLTransferable
    implements Transferable {
        Object object;

        public RJLTransferable(Object o) {
            this.object = o;
        }

        @Override
        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(df)) {
                return this.object;
            }
            throw new UnsupportedFlavorException(df);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            return df.equals(localObjectFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }
    }
}

