/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.gui;

import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.friendularity.jvision.filters.FilterInfo;
import org.friendularity.jvision.filters.FilterInfoManager;

public class FilterTree
extends JTree
implements TreeSelectionListener {
    public static final int ALL_FILTERS = 1;
    private static boolean playWithLineStyle = false;
    private static String lineStyle = "Angled";
    private static boolean DEBUG = true;
    private FilterInfo currentSelection = null;

    static DefaultMutableTreeNode nodeFactory(int selection_rule) {
        if (selection_rule != 1) {
            throw new UnsupportedOperationException("Filter filtering not implemented yet");
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Flo Filters");
        FilterInfoManager.addAllFilterInfoToTree(top);
        return top;
    }

    FilterTree(DefaultMutableTreeNode top) {
        super(top);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(this);
        if (playWithLineStyle) {
            System.out.println("line style = " + lineStyle);
            this.putClientProperty("JTree.lineStyle", lineStyle);
        }
    }

    FilterInfo getCurrentFilterSelectionOrNull() {
        return this.currentSelection;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        this.currentSelection = node.isLeaf() ? (FilterInfo)nodeInfo : null;
    }
}

