/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.photo;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.utils.Converters;

public class Photo {
    private static final int CV_INPAINT_NS = 0;
    private static final int CV_INPAINT_TELEA = 1;
    public static final int INPAINT_NS = 0;
    public static final int INPAINT_TELEA = 1;

    public static void fastNlMeansDenoising(Mat src, Mat dst, float h, int templateWindowSize, int searchWindowSize) {
        Photo.fastNlMeansDenoising_0(src.nativeObj, dst.nativeObj, h, templateWindowSize, searchWindowSize);
    }

    public static void fastNlMeansDenoising(Mat src, Mat dst) {
        Photo.fastNlMeansDenoising_1(src.nativeObj, dst.nativeObj);
    }

    public static void fastNlMeansDenoisingColored(Mat src, Mat dst, float h, float hColor, int templateWindowSize, int searchWindowSize) {
        Photo.fastNlMeansDenoisingColored_0(src.nativeObj, dst.nativeObj, h, hColor, templateWindowSize, searchWindowSize);
    }

    public static void fastNlMeansDenoisingColored(Mat src, Mat dst) {
        Photo.fastNlMeansDenoisingColored_1(src.nativeObj, dst.nativeObj);
    }

    public static void fastNlMeansDenoisingColoredMulti(List<Mat> srcImgs, Mat dst, int imgToDenoiseIndex, int temporalWindowSize, float h, float hColor, int templateWindowSize, int searchWindowSize) {
        Mat srcImgs_mat = Converters.vector_Mat_to_Mat(srcImgs);
        Photo.fastNlMeansDenoisingColoredMulti_0(srcImgs_mat.nativeObj, dst.nativeObj, imgToDenoiseIndex, temporalWindowSize, h, hColor, templateWindowSize, searchWindowSize);
    }

    public static void fastNlMeansDenoisingColoredMulti(List<Mat> srcImgs, Mat dst, int imgToDenoiseIndex, int temporalWindowSize) {
        Mat srcImgs_mat = Converters.vector_Mat_to_Mat(srcImgs);
        Photo.fastNlMeansDenoisingColoredMulti_1(srcImgs_mat.nativeObj, dst.nativeObj, imgToDenoiseIndex, temporalWindowSize);
    }

    public static void fastNlMeansDenoisingMulti(List<Mat> srcImgs, Mat dst, int imgToDenoiseIndex, int temporalWindowSize, float h, int templateWindowSize, int searchWindowSize) {
        Mat srcImgs_mat = Converters.vector_Mat_to_Mat(srcImgs);
        Photo.fastNlMeansDenoisingMulti_0(srcImgs_mat.nativeObj, dst.nativeObj, imgToDenoiseIndex, temporalWindowSize, h, templateWindowSize, searchWindowSize);
    }

    public static void fastNlMeansDenoisingMulti(List<Mat> srcImgs, Mat dst, int imgToDenoiseIndex, int temporalWindowSize) {
        Mat srcImgs_mat = Converters.vector_Mat_to_Mat(srcImgs);
        Photo.fastNlMeansDenoisingMulti_1(srcImgs_mat.nativeObj, dst.nativeObj, imgToDenoiseIndex, temporalWindowSize);
    }

    public static void inpaint(Mat src, Mat inpaintMask, Mat dst, double inpaintRadius, int flags) {
        Photo.inpaint_0(src.nativeObj, inpaintMask.nativeObj, dst.nativeObj, inpaintRadius, flags);
    }

    private static native void fastNlMeansDenoising_0(long var0, long var2, float var4, int var5, int var6);

    private static native void fastNlMeansDenoising_1(long var0, long var2);

    private static native void fastNlMeansDenoisingColored_0(long var0, long var2, float var4, float var5, int var6, int var7);

    private static native void fastNlMeansDenoisingColored_1(long var0, long var2);

    private static native void fastNlMeansDenoisingColoredMulti_0(long var0, long var2, int var4, int var5, float var6, float var7, int var8, int var9);

    private static native void fastNlMeansDenoisingColoredMulti_1(long var0, long var2, int var4, int var5);

    private static native void fastNlMeansDenoisingMulti_0(long var0, long var2, int var4, int var5, float var6, int var7, int var8);

    private static native void fastNlMeansDenoisingMulti_1(long var0, long var2, int var4, int var5);

    private static native void inpaint_0(long var0, long var2, long var4, double var6, int var8);
}

