/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.broker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.friendularity.jvision.broker.ImageStreamConsumer;
import org.friendularity.jvision.broker.ImageStreamProducer;
import org.friendularity.jvision.broker.OffAirImageStreamProducer;
import org.slf4j.LoggerFactory;

public class ImageStreamBroker {
    private static ImageStreamBroker defBroker = null;
    private final HashMap<String, ImageStreamProducer> imageStreams = new HashMap();

    public static ImageStreamBroker getDefaultImageStreamBroker() {
        if (defBroker == null) {
            defBroker = new ImageStreamBroker();
        }
        return defBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageStreamProducer(ImageStreamProducer isp) {
        HashMap<String, ImageStreamProducer> hashMap = this.imageStreams;
        synchronized (hashMap) {
            if (this.imageStreams.containsKey(isp.getSourceName())) {
                ImageStreamProducer previsp = this.imageStreams.get(isp.getSourceName());
                if (previsp instanceof OffAirImageStreamProducer) {
                    OffAirImageStreamProducer offair = (OffAirImageStreamProducer)previsp;
                    offair.switchTo(isp);
                    offair.dispose();
                } else {
                    throw new IllegalArgumentException("Image Stream " + isp.getSourceName() + " already exists");
                }
            }
            this.imageStreams.put(isp.getSourceName(), isp);
            this.imageStreams.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageStreamProducer(String name) {
        HashMap<String, ImageStreamProducer> hashMap = this.imageStreams;
        synchronized (hashMap) {
            this.imageStreams.get(name).removeAllConsumers();
            this.imageStreams.remove(name);
            this.imageStreams.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alwaysAddImageStreamConsumer(String name, ImageStreamConsumer isc) {
        HashMap<String, ImageStreamProducer> hashMap = this.imageStreams;
        synchronized (hashMap) {
            ImageStreamProducer isp = this.imageStreams.get(name);
            if (isp == null) {
                isp = new OffAirImageStreamProducer(name);
                this.imageStreams.put(name, isp);
            }
            isp.addConsumer(isc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addImageStreamConsumer(String name, ImageStreamConsumer isc) {
        HashMap<String, ImageStreamProducer> hashMap = this.imageStreams;
        synchronized (hashMap) {
            ImageStreamProducer isp = this.imageStreams.get(name);
            isp.addConsumer(isc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void waitAndAddImageStreamConsumer(String name, ImageStreamConsumer isc) {
        ImageStreamProducer isp;
        HashMap<String, ImageStreamProducer> hashMap = this.imageStreams;
        synchronized (hashMap) {
            isp = this.imageStreams.get(name);
            while (isp == null) {
                try {
                    LoggerFactory.getLogger((String)ImageStreamBroker.class.getName()).info("Waiting for stream " + name);
                    this.imageStreams.wait(1000L);
                }
                catch (InterruptedException ex) {
                    LoggerFactory.getLogger(ImageStreamBroker.class).error(ex.getMessage(), (Throwable)ex);
                }
                isp = this.imageStreams.get(name);
            }
        }
        isp.addConsumer(isc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> imageStreamNames() {
        HashMap<String, ImageStreamProducer> hashMap = this.imageStreams;
        synchronized (hashMap) {
            return this.imageStreams.keySet().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> publicImageStreamNames() {
        HashMap<String, ImageStreamProducer> hashMap = this.imageStreams;
        synchronized (hashMap) {
            HashSet<String> publicNames = new HashSet<String>();
            for (String s : this.imageStreams.keySet()) {
                if (s.contains("#")) continue;
                publicNames.add(s);
            }
            return publicNames.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imageStreamPrefixOK(String text) {
        String asPrefix = text + ".";
        if (text.trim().length() < 1) {
            return false;
        }
        HashMap<String, ImageStreamProducer> hashMap = this.imageStreams;
        synchronized (hashMap) {
            Iterator<String> names = this.imageStreamNames();
            while (names.hasNext()) {
                String s = names.next();
                if (s.startsWith(asPrefix)) {
                    return false;
                }
                if (!s.equals(text)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageStreamConsumerAllStreams(ImageStreamConsumer isc) {
        HashMap<String, ImageStreamProducer> hashMap = this.imageStreams;
        synchronized (hashMap) {
            Iterator<ImageStreamProducer> is = this.imageStreams.values().iterator();
            while (is.hasNext()) {
                is.next().removeConsumer(isc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllOfflineStreams() {
        HashMap<String, ImageStreamProducer> hashMap = this.imageStreams;
        synchronized (hashMap) {
            Iterator<ImageStreamProducer> is = this.imageStreams.values().iterator();
            while (is.hasNext()) {
                ImageStreamProducer isp = is.next();
                if (!(isp instanceof OffAirImageStreamProducer)) continue;
                isp.removeAllConsumers();
                is.remove();
            }
        }
    }
}

