/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.broker;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.friendularity.jvision.broker.ImageStreamConsumer;
import org.friendularity.jvision.broker.ImageStreamImage;
import org.friendularity.jvision.broker.ImageStreamProducer;
import org.friendularity.jvision.broker.SimpleImageStreamProducer;
import org.slf4j.LoggerFactory;

class UrOffAirImageStreamProducer
implements ImageStreamProducer,
Runnable {
    private static UrOffAirImageStreamProducer defaultProducer = null;
    private SimpleImageStreamProducer sisp = null;
    private BufferedImage img = new BufferedImage(640, 480, 5);
    private static final int IMAGE_WIDTH = 640;
    private static final int IMAGE_HEIGHT = 480;
    private static final int BIG_DOT_R = 150;
    private static final int SMALL_DOT_R = 110;
    private static Font myFont;

    private UrOffAirImageStreamProducer() {
        this.sisp = new SimpleImageStreamProducer("Err...");
        Thread t = new Thread((Runnable)this, "UrOffAirImageStreamProducer");
        t.setDaemon(true);
        t.start();
    }

    static UrOffAirImageStreamProducer getDefaultUrOffAirImageStreamProducer() {
        if (defaultProducer == null) {
            defaultProducer = new UrOffAirImageStreamProducer();
        }
        return defaultProducer;
    }

    @Override
    public String getSourceName() {
        return this.sisp.getSourceName();
    }

    @Override
    public void addConsumer(ImageStreamConsumer c) {
        this.sisp.addConsumer(c);
    }

    @Override
    public void removeAllConsumers() {
        this.sisp.removeAllConsumers();
    }

    @Override
    public void run() {
        int i = 1;
        try {
            while (true) {
                Thread.sleep(100L);
                this.paintImage(i++, this.img.getGraphics());
                this.sisp.setConsumedImage(new ImageStreamImage(this.img));
                this.sisp.setConsumedMessage(Integer.toString(i));
            }
        }
        catch (InterruptedException ex) {
            LoggerFactory.getLogger(UrOffAirImageStreamProducer.class).error(ex.getMessage(), (Throwable)ex);
            return;
        }
    }

    private void paintImage(int i, Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        g.setColor(Color.white);
        g.fillRect(0, 0, 640, 480);
        g.setColor(Color.gray);
        g.fillOval(170, 90, 300, 300);
        g.setColor(Color.gray.brighter());
        g.fillOval(210, 130, 220, 220);
        g.setColor(Color.black);
        g.drawOval(170, 90, 300, 300);
        g.drawOval(210, 130, 220, 220);
        g.drawLine(320, 240, (int)(320.0 + 640.0 * Math.sin((double)(i % 10) * Math.PI * 2.0)), (int)(240.0 + 640.0 * Math.cos((double)(i % 10) * Math.PI * 2.0)));
        String s = Integer.toString(i);
        if (myFont == null) {
            myFont = new Font("Arial", 1, 150);
        }
        g.setFont(myFont);
        g.drawString(s, 320 - g.getFontMetrics().stringWidth(s) / 2, 240 - (g.getFontMetrics().getAscent() + g.getFontMetrics().getDescent()) / 2);
    }

    @Override
    public void removeConsumer(ImageStreamConsumer c) {
        this.sisp.removeConsumer(c);
    }
}

