/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.engine;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.TreeMap;
import javax.swing.ListModel;
import org.friendularity.jvision.broker.ImageStreamBroker;
import org.friendularity.jvision.broker.ImageStreamConsumer;
import org.friendularity.jvision.broker.ImageStreamImage;
import org.friendularity.jvision.broker.SimpleImageStreamProducer;
import org.friendularity.jvision.filters.BaseFilter;
import org.friendularity.jvision.filters.FilterInfo;
import org.friendularity.jvision.filters.FilterInfoManager;
import org.friendularity.jvision.filters.FilterSequence;
import org.slf4j.LoggerFactory;

public class CVChain
implements ImageStreamConsumer {
    protected String chainName;
    protected boolean intermediatesVisible;
    protected String source;
    protected FilterSequence filters;
    protected SimpleImageStreamProducer outputProducer;

    CVChain(String chainName, boolean intermediatesVisible, String source) {
        this.chainName = chainName;
        this.intermediatesVisible = intermediatesVisible;
        this.source = source;
        this.filters = new FilterSequence();
        this.init();
    }

    public CVChain(Model M, Resource cvchain) {
        Statement s = M.getProperty(cvchain, M.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#label"));
        this.chainName = s.getObject().asLiteral().getString();
        s = M.getProperty(cvchain, M.createProperty("http://www.friendularity.org/ontology/flo#source"));
        this.source = s.getObject().asLiteral().getString();
        this.filters = new FilterSequence();
        this.intermediatesVisible = false;
        this.init();
        TreeMap<Integer, FilterInfo> filtersToAdd = new TreeMap<Integer, FilterInfo>();
        TreeMap<Integer, String> filterParms = new TreeMap<Integer, String>();
        Property p = M.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        Resource o = M.createResource("http://www.friendularity.org/ontology/flo#FilterInstance");
        ResIterator i = M.listResourcesWithProperty(p, (RDFNode)o);
        while (i.hasNext()) {
            Resource filterInstance = (Resource)i.next();
            String type = filterInstance.getProperty(M.createProperty("http://www.friendularity.org/ontology/flo#filterType")).getObject().asLiteral().getString();
            int index = filterInstance.getProperty(M.createProperty("http://www.friendularity.org/ontology/flo#index")).getObject().asLiteral().getInt();
            Resource itsChain = filterInstance.getProperty(M.createProperty("http://www.friendularity.org/ontology/flo#inChain")).getObject().asResource();
            if (!itsChain.equals((Object)cvchain)) continue;
            filtersToAdd.put(index, FilterInfoManager.getFilterInfo(type));
            String parms = filterInstance.getProperty(M.createProperty("http://www.friendularity.org/ontology/flo#filterParameters")).getObject().asLiteral().getString();
            filterParms.put(index, parms);
        }
        for (Integer ii : filtersToAdd.keySet()) {
            BaseFilter f = ((FilterInfo)filtersToAdd.get(ii)).createInstance();
            f.deserialize((String)filterParms.get(ii));
            this.filters.add(f);
        }
    }

    private void init() {
        LoggerFactory.getLogger((String)CVChain.class.getName()).info("about to wire up imagestream");
        ImageStreamBroker.getDefaultImageStreamBroker().alwaysAddImageStreamConsumer(this.source, this);
        this.outputProducer = new SimpleImageStreamProducer(this.getOutName());
        ImageStreamBroker.getDefaultImageStreamBroker().addImageStreamProducer(this.outputProducer);
        LoggerFactory.getLogger((String)CVChain.class.getName()).info("done wiring up imagestream");
        this.filters.sendOutputTo(this.outputProducer);
    }

    public String getName() {
        return this.chainName;
    }

    public String getSource() {
        return this.source;
    }

    public String getOutName() {
        return this.chainName + ".out";
    }

    public ListModel getFilterSequence() {
        return this.filters;
    }

    public void unwire() {
        ImageStreamBroker.getDefaultImageStreamBroker().removeImageStreamConsumerAllStreams(this);
        ImageStreamBroker.getDefaultImageStreamBroker().removeImageStreamProducer(this.outputProducer.getSourceName());
    }

    @Override
    public void setConsumedImage(ImageStreamImage in) {
        this.filters.setConsumedImage(in);
    }

    @Override
    public void setConsumedMessage(String string) {
    }

    @Override
    public void sourceIsEnding() {
    }
}

