/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.filters;

import javax.swing.JFrame;
import org.friendularity.jvision.filters.ApplicativeBaseFilter;
import org.friendularity.jvision.filters.FilterParams;
import org.friendularity.jvision.filters.ParamChangedListener;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class Blur
extends ApplicativeBaseFilter
implements ParamChangedListener {
    private Size kernal = new Size(13.0, 13.0);
    private double kernalSize = 13.0;

    @Override
    public void apply(Mat in, Mat out) {
        Imgproc.blur(in, out, this.kernal);
    }

    public String toString() {
        return "blur";
    }

    @Override
    public void showParamUI(JFrame parent) {
        FilterParams.showParamWidget(this, "blur radius,slider,1," + this.kernalSize + ",36");
    }

    @Override
    public String serialize() {
        return Double.toString(this.kernalSize);
    }

    @Override
    public void deserialize(String str) {
        this.kernalSize = Double.parseDouble(str);
        this.kernal = new Size(this.kernalSize, this.kernalSize);
    }

    @Override
    public void paramChanged(int index, String param) {
        this.kernalSize = Double.parseDouble(param);
        this.kernal = new Size(this.kernalSize, this.kernalSize);
    }
}

