/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.filters;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import javax.swing.JFrame;
import org.friendularity.jvision.filters.ApplicativeBaseFilter;
import org.friendularity.jvision.gui.FileLocations;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfRect;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.objdetect.CascadeClassifier;

public abstract class CascadeDetector
extends ApplicativeBaseFilter {
    protected abstract CascadeClassifier getDetector();

    protected abstract void setDetector(CascadeClassifier var1);

    protected abstract FileLocations.CascadeType cascadeType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureTransient() {
        if (this.getDetector() != null) {
            return;
        }
        InputStream inputStream = null;
        BufferedReader br = null;
        FileWriter fw = null;
        File outputs = null;
        try {
            String line;
            outputs = File.createTempFile("File", FileLocations.cascadeTempfileName(this.cascadeType()));
            fw = new FileWriter(outputs);
            inputStream = CascadeClassifier.class.getResourceAsStream(FileLocations.cascadeResourceLocation(this.cascadeType()));
            br = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = br.readLine()) != null) {
                fw.write(line + "\n");
            }
            try {
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setDetector(new CascadeClassifier(outputs.getAbsolutePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void apply(Mat in, Mat out) {
        try {
            this.ensureTransient();
            MatOfRect faceDetections = new MatOfRect();
            this.getDetector().detectMultiScale(in, faceDetections);
            in.clone().copyTo(out);
            Scalar color = this.boxColor();
            LinkedList<Rectangle> pubRects = new LinkedList<Rectangle>();
            for (Rect rect : faceDetections.toArray()) {
                Core.rectangle(out, new Point(rect.x, rect.y), new Point(rect.x + rect.width, rect.y + rect.height), color);
                pubRects.add(new Rectangle(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height));
                this.publishObservation(pubRects);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            in.clone().copyTo(out);
        }
    }

    protected abstract Scalar boxColor();

    public String toString() {
        return "abstract_cascade_detector";
    }

    @Override
    public void showParamUI(JFrame parent) {
    }

    @Override
    public String serialize() {
        return "";
    }

    @Override
    public void deserialize(String str) {
    }

    private void publishObservation(LinkedList<Rectangle> pubRects) {
    }
}

