/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.gui;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.friendularity.jvision.engine.CVChain;
import org.friendularity.jvision.filters.FilterSequence;
import org.friendularity.jvision.gui.CVChainControlBorder;
import org.friendularity.jvision.gui.FilterBox;
import org.friendularity.jvision.gui.FilterList;

public class CVChainControl
extends JPanel {
    private CVChain chain;
    private JLabel nameField;
    private FilterList filters;
    private JLabel sourceField;
    private JLabel outField;
    private FilterBox myFilterBox;

    @Deprecated
    CVChainControl(FilterBox fb, Model M, Resource cvchain) {
        CVChain chain = new CVChain(M, cvchain);
        this.init(chain, fb);
    }

    private Border borderFactory() {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0, this.getBackground().brighter(), this.getBackground().darker()), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
    }

    public CVChainControl(CVChain chain, FilterBox aFilterBox) {
        this.init(chain, aFilterBox);
    }

    private void init(CVChain chain, FilterBox aFilterBox) {
        this.chain = chain;
        this.myFilterBox = aFilterBox;
        this.setLayout(new BoxLayout(this, 1));
        JPanel nameBox = new JPanel();
        nameBox.setLayout(new BoxLayout(nameBox, 1));
        nameBox.setBorder(this.borderFactory());
        nameBox.add(new JLabel("name:"));
        this.nameField = new JLabel(chain.getName());
        nameBox.add(this.nameField);
        this.add(nameBox);
        nameBox.setAlignmentX(0.5f);
        JPanel sourceBox = new JPanel();
        sourceBox.setLayout(new BoxLayout(sourceBox, 1));
        sourceBox.setAlignmentX(0.5f);
        JLabel sourceFieldLabel = new JLabel("Source:");
        sourceBox.add(sourceFieldLabel);
        this.sourceField = new JLabel(chain.getSource());
        sourceBox.add(this.sourceField);
        sourceBox.setBorder(this.borderFactory());
        sourceBox.setAlignmentX(0.5f);
        this.add(sourceBox);
        JPanel filterListBox = new JPanel();
        filterListBox.setLayout(new BoxLayout(filterListBox, 1));
        JLabel flbLabel = new JLabel("filters");
        flbLabel.setAlignmentX(0.5f);
        filterListBox.add(flbLabel);
        this.filters = new FilterList();
        this.filters.setModel(chain.getFilterSequence());
        filterListBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6), BorderFactory.createLineBorder(Color.BLACK)));
        filterListBox.add(this.filters);
        this.add(filterListBox);
        this.outField = new JLabel(chain.getOutName());
        this.outField.setAlignmentX(0.5f);
        this.outField.setBorder(this.borderFactory());
        this.add(this.outField);
        this.setMinimumSize(new Dimension(0, 600));
        this.setAlignmentY(0.0f);
        this.setAlignmentX(0.5f);
        this.setBorder(new CVChainControlBorder(this));
        this.addMouseListener(new MouseAdapter(){
            CVChainControl oldSelection = null;

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                this.oldSelection = CVChainControl.this.myFilterBox.getSelectedCVChainControl();
                CVChainControl.this.myFilterBox.setSelectedChainControl(CVChainControl.this);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (e.getX() < 0 || e.getY() < 0 || e.getX() >= CVChainControl.this.getWidth() || e.getY() >= CVChainControl.this.getHeight()) {
                    CVChainControl.this.myFilterBox.setSelectedChainControl(this.oldSelection);
                }
            }
        });
    }

    @Override
    public String getName() {
        return this.chain.getName();
    }

    boolean isSelected() {
        CVChainControl cvcc = this.myFilterBox.getSelectedCVChainControl();
        return this == cvcc;
    }

    FilterSequence getFilterSequence() {
        return (FilterSequence)this.filters.getModel();
    }

    void removeSelectedFilter() {
        int i = this.filters.getSelectedIndex();
        if (i >= 0) {
            ((FilterSequence)this.filters.getModel()).remove(i);
        }
    }

    void addSelfToModel(Model M) {
        Resource cv = M.createResource("http://www.friendularity.org/cv#cvchain" + this.chain.getName());
        M.add(M.createStatement(cv, M.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)M.createResource("http://www.friendularity.org/ontology/flo#CVChain")));
        M.add(M.createStatement(cv, M.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#label"), (RDFNode)M.createLiteral(this.chain.getName())));
        M.add(M.createStatement(cv, M.createProperty("http://www.friendularity.org/ontology/flo#source"), (RDFNode)M.createLiteral(this.chain.getSource())));
        M.add(M.createStatement(cv, M.createProperty("http://www.friendularity.org/ontology/flo#intermediatesVisible"), (RDFNode)M.createLiteral(Boolean.FALSE.toString())));
        FilterSequence fs = (FilterSequence)this.chain.getFilterSequence();
        for (int i = 0; i < fs.getSize(); ++i) {
            String f = fs.getElementAt(i).toString();
            Resource frsrc = M.createResource("http://www.friendularity.org/cv#filter/" + this.chain.getName() + "/" + Integer.toString(i));
            M.add(M.createStatement(frsrc, M.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)M.createResource("http://www.friendularity.org/ontology/flo#FilterInstance")));
            M.add(M.createStatement(frsrc, M.createProperty("http://www.friendularity.org/ontology/flo#inChain"), (RDFNode)cv));
            M.add(M.createStatement(frsrc, M.createProperty("http://www.friendularity.org/ontology/flo#index"), (RDFNode)M.createLiteral(Integer.toString(i))));
            M.add(M.createStatement(frsrc, M.createProperty("http://www.friendularity.org/ontology/flo#filterType"), (RDFNode)M.createLiteral(f)));
            M.add(M.createStatement(frsrc, M.createProperty("http://www.friendularity.org/ontology/flo#filterParameters"), (RDFNode)M.createLiteral(fs.serializeIndex(i))));
        }
    }

    void showParametersOfSelectedFilter() {
        int i = this.filters.getSelectedIndex();
        if (i >= 0) {
            ((FilterSequence)this.filters.getModel()).showParamUIForIndex(i);
        }
    }
}

