/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.gui;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.friendularity.jvision.broker.ImageStreamBroker;
import org.friendularity.jvision.engine.CVChainManager;
import org.friendularity.jvision.engine.JVisionEngine;
import org.friendularity.jvision.engine.JVisionRDF;
import org.friendularity.jvision.filters.FilterInfo;
import org.friendularity.jvision.gui.CVChainControl;
import org.friendularity.jvision.gui.CVChainInfoDialog;
import org.friendularity.jvision.gui.FilterTree;
import org.friendularity.jvision.gui.JVisionFrame;

public class FilterBox
extends JPanel {
    private JMenuBar myMenuBar;
    private FilterTree tree;
    private JPanel listPanel;
    private CVChainControl selectedCVChainControl = null;
    private static boolean useSystemLookAndFeel = false;
    private Model last_saved_model = JVisionRDF.createDefaultJVisionModel();
    private File last_saved_name = null;

    public FilterBox() {
        super(new GridLayout(1, 0));
        this.tree = new FilterTree(FilterTree.nodeFactory(1));
        JScrollPane treeView = new JScrollPane(this.tree);
        this.listPanel = new JPanel();
        this.listPanel.setLayout(new BoxLayout(this.listPanel, 2));
        this.listPanel.setBackground(this.listPanel.getBackground().darker());
        JScrollPane filterListsView = new JScrollPane(this.listPanel);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setTopComponent(treeView);
        splitPane.setBottomComponent(filterListsView);
        Dimension minimumSize = new Dimension(100, 50);
        filterListsView.setMinimumSize(minimumSize);
        treeView.setMinimumSize(minimumSize);
        splitPane.setDividerLocation(200);
        splitPane.setPreferredSize(new Dimension(800, 500));
        this.add(splitPane);
    }

    private void removeAllCVChains() {
        int i = 0;
        while (i < this.listPanel.getComponentCount()) {
            if (!(this.listPanel.getComponent(i) instanceof CVChainControl)) continue;
            CVChainControl cvcc = (CVChainControl)this.listPanel.getComponent(i);
            CVChainManager.getDefaultManager().remove(this, cvcc);
            this.listPanel.remove(cvcc);
        }
    }

    private void setupMenus(JFrame frame) {
        this.myMenuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        this.myMenuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("New", 78);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JVisionFrame.theLogger.debug("New");
                if (!FilterBox.this.saveAsViaDirtyBit()) {
                    return;
                }
                FilterBox.this.removeAllCVChains();
                FilterBox.this.last_saved_model = JVisionRDF.createDefaultJVisionModel();
                ImageStreamBroker.getDefaultImageStreamBroker().removeAllOfflineStreams();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Open...", 79);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!FilterBox.this.saveAsViaDirtyBit()) {
                    return;
                }
                JFileChooser fc = new JFileChooser();
                fc.setDialogType(0);
                fc.setFileFilter(new FileNameExtensionFilter("flo files", "flo", "ttl"));
                if (FilterBox.this.last_saved_name != null) {
                    fc.setCurrentDirectory(FilterBox.this.last_saved_name);
                    fc.setSelectedFile(FilterBox.this.last_saved_name);
                } else {
                    fc.setCurrentDirectory(new File(System.getProperty("user.dir")));
                }
                if (fc.showOpenDialog(FilterBox.this) == 0) {
                    FilterBox.this.last_saved_name = fc.getSelectedFile();
                    String path = "";
                    try {
                        path = FilterBox.this.last_saved_name.getCanonicalPath();
                        FileInputStream fis = new FileInputStream(FilterBox.this.last_saved_name);
                        Model M = JVisionRDF.createDefaultJVisionModel();
                        M.read((InputStream)fis, "http://www.friendularity.org/cv#", "TURTLE");
                        fis.close();
                        FilterBox.this.last_saved_model = M;
                        FilterBox.this.removeAllCVChains();
                        FilterBox.this.createUIFromModel(M);
                        ImageStreamBroker.getDefaultImageStreamBroker().removeAllOfflineStreams();
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(FilterBox.this, "Cannot Open File", "Can't open " + path, 2);
                    }
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save", 83);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (FilterBox.this.last_saved_name == null) {
                    FilterBox.this.saveAs();
                } else {
                    String path = "";
                    try {
                        path = FilterBox.this.last_saved_name.getCanonicalPath();
                        FileWriter fw = new FileWriter(FilterBox.this.last_saved_name);
                        Model M = FilterBox.this.getRDFModel();
                        M.write((Writer)fw, "TURTLE", "http://www.friendularity.org/cv#");
                        FilterBox.this.last_saved_model = M;
                        fw.close();
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(FilterBox.this, "Can't Save", "Can't save in " + path, 2);
                    }
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save As...", 65);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FilterBox.this.saveAs();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Quit...", 81);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FilterBox.this.saveAsViaDirtyBit();
                JVisionEngine.getDefaultJVisionEngine().requestQuit();
            }
        });
        menu.add(menuItem);
        menu = new JMenu("CVChain");
        menu.setMnemonic(70);
        menuItem = new JMenuItem("Add...", 65);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JVisionFrame.theLogger.debug("add a FilterSeq...");
                CVChainInfoDialog cvcid = new CVChainInfoDialog(FilterBox.this, CVChainManager.getDefaultManager());
                cvcid.setVisible(true);
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Remove", 82);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (FilterBox.this.selectedCVChainControl == null) {
                    return;
                }
                CVChainManager.getDefaultManager().remove(FilterBox.this, FilterBox.this.selectedCVChainControl);
            }
        });
        menu.add(menuItem);
        this.myMenuBar.add(menu);
        menu = new JMenu("Filter");
        menuItem = new JMenuItem("Add...", 65);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (FilterBox.this.selectedCVChainControl == null) {
                    return;
                }
                FilterInfo fi = FilterBox.this.tree.getCurrentFilterSelectionOrNull();
                if (fi == null) {
                    return;
                }
                FilterBox.this.selectedCVChainControl.getFilterSequence().add(fi.createInstance());
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Remove", 82);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FilterBox.this.selectedCVChainControl.removeSelectedFilter();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Parameters...", 80);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterBox.this.selectedCVChainControl.showParametersOfSelectedFilter();
            }
        });
        menu.add(menuItem);
        this.myMenuBar.add(menu);
        frame.setJMenuBar(this.myMenuBar);
    }

    private static void createAndShowGUI() {
        if (useSystemLookAndFeel) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                System.err.println("Couldn't use system look and feel.");
            }
        }
        JFrame frame = new JFrame("Filter Box");
        frame.setDefaultCloseOperation(3);
        FilterBox fb = new FilterBox();
        frame.add(fb);
        fb.setupMenus(frame);
        frame.pack();
        frame.setVisible(true);
    }

    public static void showFilterBox() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FilterBox.createAndShowGUI();
            }
        });
    }

    Frame getFrame() {
        Container p = this;
        while (!(p instanceof Frame)) {
            p = p.getParent();
        }
        return (Frame)p;
    }

    public void setSelectedChainControl(CVChainControl current) {
        this.selectedCVChainControl = current;
        int n = this.listPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.listPanel.getComponent(i);
            if (!(c instanceof CVChainControl)) continue;
            c.repaint();
        }
    }

    public void addCVChainControl(CVChainControl cvChainControl) {
        this.listPanel.add(cvChainControl);
        this.setSelectedChainControl(cvChainControl);
        cvChainControl.revalidate();
        this.listPanel.repaint();
    }

    CVChainControl getSelectedCVChainControl() {
        if (this.selectedCVChainControl != null) {
            return this.selectedCVChainControl;
        }
        int n = this.listPanel.getComponentCount();
        CVChainControl candidate = null;
        for (int i = 0; i < n; ++i) {
            Component c = this.listPanel.getComponent(i);
            if (!(c instanceof CVChainControl)) continue;
            if (candidate != null) {
                return null;
            }
            candidate = (CVChainControl)c;
        }
        this.selectedCVChainControl = candidate;
        return this.selectedCVChainControl;
    }

    public void removeChainControl(CVChainControl cvcc) {
        this.listPanel.remove(cvcc);
        if (this.selectedCVChainControl == cvcc) {
            this.selectedCVChainControl = null;
        }
        this.revalidate();
        this.repaint();
    }

    private boolean saveAsViaDirtyBit() {
        Model M = this.getRDFModel();
        if (this.last_saved_model == null || !this.last_saved_model.isIsomorphicWith(M)) {
            int response;
            Object[] options = new Object[]{"Save", "Don't Save", "Cancel"};
            String filename = "Untitled";
            if (this.last_saved_name != null) {
                filename = this.last_saved_name.getName();
            }
            if ((response = JOptionPane.showOptionDialog(this, "Do you want to save changes to " + filename, "FilterBox", 1, -1, null, options, options[2])) == 2) {
                return false;
            }
            if (response == 0) {
                return this.saveAs();
            }
        }
        return true;
    }

    private void createUIFromModel(Model M) {
        Property p = M.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        Resource o = M.createResource("http://www.friendularity.org/ontology/flo#CVChain");
        ResIterator i = M.listResourcesWithProperty(p, (RDFNode)o);
        while (i.hasNext()) {
            Resource cvchain = (Resource)i.next();
            CVChainManager.getDefaultManager().buildChain(this, cvchain, M);
        }
        this.listPanel.revalidate();
    }

    private Model getRDFModel() {
        Model M = JVisionRDF.createDefaultJVisionModel();
        Component[] cs = this.listPanel.getComponents();
        for (int i = 0; i < cs.length; ++i) {
            if (!(cs[i] instanceof CVChainControl)) continue;
            ((CVChainControl)cs[i]).addSelfToModel(M);
        }
        return M;
    }

    private boolean saveAs() {
        Model M = this.getRDFModel();
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(1);
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileNameExtensionFilter("flo files", "flo", "ttl"));
        if (this.last_saved_name != null) {
            fc.setCurrentDirectory(this.last_saved_name);
            fc.setSelectedFile(this.last_saved_name);
        } else {
            fc.setSelectedFile(new File("*.flo"));
            fc.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        if (fc.showSaveDialog(this) == 0) {
            this.last_saved_name = fc.getSelectedFile();
            String path = "";
            try {
                int res;
                path = this.last_saved_name.getCanonicalPath();
                if (this.last_saved_name.exists() && ((res = JOptionPane.showConfirmDialog(this, "File Exists", path + " Exists, OK to overwrite?", 2)) == 2 || res == 1)) {
                    return false;
                }
                FileWriter fw = new FileWriter(this.last_saved_name);
                M.write((Writer)fw, "TURTLE", "http://www.friendularity.org/cv#");
                this.last_saved_model = M;
                fw.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Can't Save", "Can't save in " + path, 2);
                return false;
            }
            return true;
        }
        return false;
    }
}

