/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.gui;

import org.appdapter.core.log.BasicDebugger;
import org.friendularity.jvision.engine.JVisionEngine;
import org.friendularity.jvision.engine.Quitter;
import org.friendularity.jvision.gui.JVisionFrame;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class JVisionLauncher
extends BasicDebugger
implements Quitter {
    private JVisionEngine myEngine;
    private Thread myCamProcThread;
    private JVisionFrame myDemoFrame;
    private Boolean myFlag_QuittingNow = Boolean.FALSE;
    private boolean myFlag_StopOSGiAfterQuit = false;

    public static void main(String[] args) {
        JVisionLauncher jvl = new JVisionLauncher(false);
        jvl.attemptInit();
    }

    public JVisionLauncher(boolean flag_stopOSGiAfterQuit) {
        this.myEngine = JVisionEngine.getDefaultJVisionEngine();
        this.myDemoFrame = new JVisionFrame();
        this.myDemoFrame.setQuitter(this);
        this.myFlag_StopOSGiAfterQuit = flag_stopOSGiAfterQuit;
    }

    public boolean attemptInit() {
        boolean connectedOK = this.myEngine.connect();
        if (connectedOK) {
            this.myDemoFrame.showFilterBox();
            this.myEngine.setQuitter(this);
            return this.startThread();
        }
        return false;
    }

    private boolean startThread() {
        this.myCamProcThread = new Thread(this.myEngine);
        this.myCamProcThread.start();
        return true;
    }

    public void requestStop(Boolean optionalFlag_stopOSGiAfterQuit) {
        if (optionalFlag_stopOSGiAfterQuit != null) {
            this.myFlag_StopOSGiAfterQuit = optionalFlag_stopOSGiAfterQuit;
        }
        this.setWantsToQuit(true);
    }

    private void forceStop() {
        this.myCamProcThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wantsToQuit() {
        Boolean bl = this.myFlag_QuittingNow;
        synchronized (bl) {
            return this.myFlag_QuittingNow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWantsToQuit(boolean x) {
        Boolean bl = this.myFlag_QuittingNow;
        synchronized (bl) {
            this.myFlag_QuittingNow = new Boolean(x);
        }
    }

    @Override
    public void notifyQuitCompleted() {
        if (this.myFlag_StopOSGiAfterQuit) {
            this.getLogger().info("Now that quit has completed, we will shutdown our OSGi container");
            this.shutdownOurOSGiContainer();
        }
    }

    private void shutdownOurOSGiContainer() {
        Bundle anyB = FrameworkUtil.getBundle(this.getClass());
        BundleContext anyBC = anyB.getBundleContext();
        this.stopOSGiContainer(anyBC);
    }

    private void stopOSGiContainer(BundleContext bc) {
        Bundle sysB = bc.getBundle(0L);
        this.getLogger().warn("Asking system bundle to stop(): {}", (Object)sysB);
        try {
            sysB.stop();
        }
        catch (Throwable t) {
            this.getLogger().error("Caught exception during sys-bundle.stop() request", t);
        }
    }
}

