/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.datmat;

import au.com.bytecode.opencsv.CSVReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.appdapter.core.log.BasicDebugger;

public class TestSheetRead {
    static BasicDebugger theDbg = new BasicDebugger();
    static String gdocPubUrlWithKey = "https://docs.google.com/spreadsheet/pub?key=0ArBjkBoH40tndDdsVEVHZXhVRHFETTB5MGhGcWFmeGc";
    static String tmpExtender = "&single=true&gid=7&range=A2%3AK999&output=csv";
    static List<String[]> theFailedRowList = new ArrayList<String[]>();

    public static void main(String[] args) {
        Reader shdr = TestSheetRead.makeSheetDataReader();
        theDbg.logInfo("Got sheet reader: " + shdr);
        List<String[]> resultRows = TestSheetRead.readAllRows(shdr);
        for (String[] cells : resultRows) {
            theDbg.logInfo("--------------------------------Row Break------------------------");
            for (String c : cells) {
                theDbg.logInfo("Got cell: " + c);
            }
        }
    }

    public static Reader makeSheetDataReader() {
        InputStreamReader sheetReader = null;
        String fullUrlTxt = gdocPubUrlWithKey + tmpExtender;
        try {
            URL url = new URL(fullUrlTxt);
            URLConnection urlc = url.openConnection();
            InputStream istream = urlc.getInputStream();
            sheetReader = new InputStreamReader(istream);
        }
        catch (Throwable t) {
            theDbg.logError("Cannot read[" + fullUrlTxt + "]", t);
        }
        return sheetReader;
    }

    public static List<String[]> readAllRows(Reader matDataReader) {
        List resultRows = theFailedRowList;
        try {
            CSVReader csvr = new CSVReader(matDataReader);
            resultRows = csvr.readAll();
        }
        catch (Throwable t) {
            theDbg.logError("Failed during CSV parse", t);
        }
        return resultRows;
    }
}

