/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.api.struct;

import org.cogchar.bind.symja.MathGate;
import org.friendularity.api.struct.NumericNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MathExprNode<NumType>
extends NumericNode<NumType> {
    static Logger theLogger = LoggerFactory.getLogger(MathExprNode.class);
    private String myMathExpr;

    public MathExprNode(String mExpr, int dim, NumType outObj) {
        super(dim, outObj);
        this.myMathExpr = mExpr;
    }

    @Override
    protected void readDoublesIntoBuf(MathGate mathGate, double[] buffer) {
        if (this.myMathExpr != null) {
            mathGate.parseAndEvalExprToDoubleVec(this.myMathExpr, buffer);
        } else {
            theLogger.debug("No expression found.");
        }
    }

    public void setMathExpr(String mathExpr) {
        this.clearResultCache();
        this.myMathExpr = mathExpr;
    }
}

