/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.api.struct;

import org.cogchar.bind.symja.MathGate;
import org.friendularity.api.struct.NumericMapper;

public abstract class NumericNode<NumType>
implements NumericMapper<NumType> {
    private NumType myCachedResultObj;
    private double[] myBuffer;
    private NumericMapper myOptMapperDelegate;

    public NumericNode(int dim, NumType initNumObj) {
        this.myBuffer = new double[dim];
        this.myCachedResultObj = initNumObj;
    }

    public NumType getOutputObject() {
        return this.myCachedResultObj;
    }

    @Override
    public void writeNumericFromDoublesBuf(NumType outObj, double[] buffer) {
        if (this.myOptMapperDelegate != null) {
            this.myOptMapperDelegate.writeNumericFromDoublesBuf(outObj, buffer);
        } else {
            this.writeAnyNumericFromAnyDoublesBuf(outObj, buffer);
        }
    }

    protected void writeAnyNumericFromAnyDoublesBuf(NumType outObj, double[] buffer) {
        throw new UnsupportedOperationException("NumericNodes should either set a NumberMapper delegate, or override this method!");
    }

    protected abstract void readDoublesIntoBuf(MathGate var1, double[] var2);

    protected void clearResultCache() {
        this.myCachedResultObj = null;
    }

    public void doUpdate(MathGate mathGate) {
        this.readDoublesIntoBuf(mathGate, this.myBuffer);
        this.writeAnyNumericFromAnyDoublesBuf(this.myCachedResultObj, this.myBuffer);
    }
}

