/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.api.west;

import java.util.HashSet;
import java.util.Set;
import org.appdapter.core.name.FreeIdent;
import org.appdapter.core.name.Ident;
import org.cogchar.bind.symja.MathGate;
import org.friendularity.api.west.CompoundEstimate;
import org.friendularity.api.west.EstimateLib;
import org.friendularity.api.west.PersonEstimate;
import org.friendularity.api.west.SelfEstimate;
import org.friendularity.api.west.StuffEstimate;
import org.friendularity.api.west.ThingEstimate;
import org.matheclipse.core.interfaces.IExpr;

public class WorldEstimate
extends CompoundEstimate {
    public static String ESTIM_NS = "http://friendularity.org/estimate#";
    public SelfEstimate mySelfEstim;
    public Set<PersonEstimate> myPersonEstims = new HashSet<PersonEstimate>();
    public Set<StuffEstimate> myStuffEstims = new HashSet<StuffEstimate>();
    boolean mathNeedsInit = true;
    public double mult_A = 1.0;

    public WorldEstimate(Ident id) {
        super(id);
    }

    @Override
    protected void ensureSubpartsExist() {
        if (this.mySelfEstim == null) {
            FreeIdent selfEstID = new FreeIdent(ESTIM_NS + "self_estim_88");
            this.mySelfEstim = new SelfEstimate((Ident)selfEstID);
        }
        if (this.myPersonEstims == null || this.myPersonEstims.isEmpty()) {
            this.myPersonEstims = EstimateLib.makeFunPersonEstims();
        }
        if (this.myStuffEstims == null || this.myStuffEstims.isEmpty()) {
            this.myStuffEstims = EstimateLib.makeFunStuffEstims(12, 8);
        }
    }

    @Override
    public void updateFromMathSpace(MathGate mg) {
        long nowMsec = System.currentTimeMillis();
        double nowSec = (double)nowMsec / 1000.0;
        mg.putVar("$nowSec", (Object)new Double(nowSec));
        mg.putVar("$multA", (Object)new Double(this.mult_A));
        if (this.mathNeedsInit) {
            mg.putVar("$startSec", (Object)new Double(nowSec));
            mg.putVar("$cycleSec", (Object)new Double(3.0));
            this.mathNeedsInit = false;
        }
        IExpr globs1 = mg.parseAndEvalExprToIExpr("$elapsed:=$nowSec-$startSec; $cycles:=Floor[$elapsed/$cycleSec]");
        IExpr globs2 = mg.parseAndEvalExprToIExpr("$phaseFrac:=$elapsed/$cycleSec-$cycles; $phaseAng:=2.0*Pi*$phaseFrac");
        this.ensureSubpartsExist();
        super.updateFromMathSpace(mg);
    }

    @Override
    public Set<ThingEstimate> getSubEstimates() {
        this.ensureSubpartsExist();
        HashSet<ThingEstimate> subs = new HashSet<ThingEstimate>();
        if (this.mySelfEstim != null) {
            subs.add(this.mySelfEstim);
        }
        subs.addAll(this.myPersonEstims);
        subs.addAll(this.myStuffEstims);
        return subs;
    }

    public static interface Consumer {
        public void setWorldEstimate(WorldEstimate var1);
    }
}

