/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.closing;

import java.net.URISyntaxException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.url.URLSyntaxException;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.util.EmptyAdapter;
import org.jflux.api.messaging.rk.services.ServiceCommand;
import org.jflux.impl.messaging.rk.JMSAvroMessageSender;
import org.jflux.impl.messaging.rk.ServiceCommandRecord;

public class SpeechServerCloser {
    private final String myBrokerIPAddress;

    public SpeechServerCloser() {
        this("127.0.0.1");
    }

    public SpeechServerCloser(String brokerIPAddress) {
        this.myBrokerIPAddress = brokerIPAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException, URISyntaxException {
        Connection connection = this.buildConnection();
        try (Session session = connection.createSession(false, 2);){
            connection.start();
            try {
                AMQQueue cmdDest = new AMQQueue("speechCommand; {create: always, node: {type: queue}}");
                JMSAvroMessageSender cmdSender = new JMSAvroMessageSender(session, (Destination)cmdDest);
                cmdSender.setAdapter((Adapter)new EmptyAdapter());
                cmdSender.setDefaultContentType("application/service-command");
                cmdSender.start();
                try {
                    this.sendStopCommandRecord((JMSAvroMessageSender<ServiceCommand, ServiceCommandRecord>)cmdSender);
                }
                finally {
                    cmdSender.stop();
                }
            }
            finally {
                connection.stop();
            }
        }
    }

    private Connection buildConnection() throws URLSyntaxException, JMSException {
        String brokerTCP_Addr = this.myBrokerIPAddress + ":5672";
        String brokerAMQP_URL = "amqp://admin:admin@clientid/test?brokerlist='tcp://" + brokerTCP_Addr + "'";
        AMQConnectionFactory cf = new AMQConnectionFactory(brokerAMQP_URL);
        return cf.createConnection();
    }

    private void sendStopCommandRecord(JMSAvroMessageSender<ServiceCommand, ServiceCommandRecord> cmdSender) {
        ServiceCommandRecord serviceCommandRecord = new ServiceCommandRecord();
        serviceCommandRecord.setCommand("stop");
        serviceCommandRecord.setTimestampMillisecUTC(Long.valueOf(System.currentTimeMillis()));
        serviceCommandRecord.setSourceId("source");
        serviceCommandRecord.setDestinationId("destination");
        cmdSender.sendMessage((Object)serviceCommandRecord, "application/service-command");
    }

    public String toString() {
        return "SpeechServerCloser{brokerIPAddress='" + this.myBrokerIPAddress + '\'' + '}';
    }
}

