/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.impl.visual;

import com.jme3.asset.AssetManager;
import com.jme3.scene.Node;
import org.appdapter.core.name.FreeIdent;
import org.appdapter.core.name.Ident;
import org.cogchar.blob.emit.RenderConfigEmitter;
import org.cogchar.render.app.humanoid.HumanoidRenderContext;
import org.cogchar.render.opengl.optic.ViewportFacade;
import org.cogchar.render.sys.registry.RenderRegistryClient;
import org.cogchar.render.trial.TrialContent;
import org.friendularity.api.west.WorldEstimate;
import org.friendularity.impl.visual.DeicticVisualizer;
import org.friendularity.impl.visual.MeshTest;
import org.friendularity.impl.visual.SingleShapeVisualizer;

public class DemoWorldVisualizer
extends SingleShapeVisualizer<WorldEstimate> {
    private TrialContent myTrialContent;
    private boolean myFlag_deicticVisualization = true;

    public DemoWorldVisualizer(HumanoidRenderContext hrc) {
        super(hrc, (Ident)new FreeIdent(WorldEstimate.ESTIM_NS + "demo_world_808"));
    }

    public void makeBonusMeshes() {
        RenderRegistryClient rrc = this.getRenderRegistryClient();
        AssetManager amgr = rrc.getJme3AssetManager(null);
        Node rootNode = rrc.getJme3RootDeepNode(null);
        RenderConfigEmitter rce = this.getConfigEmitter();
        MeshTest mt = new MeshTest();
        mt.makeStuff(amgr, rootNode);
        this.initTrialContent_onRendThrd();
        if (this.myFlag_deicticVisualization) {
            this.startDeicticVisualizer();
        }
    }

    public void initTrialContent_onRendThrd() {
        this.myTrialContent = new TrialContent();
        RenderRegistryClient rrc = this.getRenderRegistryClient();
        Node rootDeepNode = rrc.getJme3RootDeepNode(null);
        ViewportFacade vf = rrc.getOpticViewportFacade(null);
        AssetManager assetMgr = rrc.getJme3AssetManager(null);
        Node guiNode = rrc.getJme3RootOverlayNode(null);
        this.myTrialContent.initContent3D_onRendThread(rrc, rootDeepNode);
        this.myTrialContent.initContent2D_onRendThread(rrc, guiNode, assetMgr);
    }

    public TrialContent getTrialContent() {
        return this.myTrialContent;
    }

    @Override
    public void updateDisplay_onRendThrd(WorldEstimate we, float timePerFrame) {
        super.updateDisplay_onRendThrd(we, timePerFrame);
        if (this.myTrialContent != null) {
            RenderRegistryClient rrc = this.getRenderRegistryClient();
            this.myTrialContent.doUpdate(rrc, timePerFrame);
        }
    }

    public void startDeicticVisualizer() {
        DeicticVisualizer deictViz = new DeicticVisualizer(this);
        deictViz.connectToTrialContent(this.getTrialContent());
        deictViz.forceHeadCameraOntoSinbad();
        deictViz.putVizPyramidOnDefaultCam();
        deictViz.setupNiftyPointingRays();
    }
}

