/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.impl.visual;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cogchar.render.app.humanoid.HumanoidRenderContext;
import org.cogchar.render.goody.dynamic.VizShapeSiblingGroup;
import org.friendularity.api.west.CompoundEstimate;
import org.friendularity.api.west.ThingEstimate;
import org.friendularity.impl.visual.BaseVisualizer;
import org.friendularity.impl.visual.EstimateVisualizer;
import org.friendularity.impl.visual.SingleShapeVisualizer;

public abstract class GroupVisualizer<CTE extends CompoundEstimate>
extends BaseVisualizer<CTE> {
    private Map<ThingEstimate, EstimateVisualizer> mySubVizMap = new HashMap<ThingEstimate, EstimateVisualizer>();

    public GroupVisualizer(HumanoidRenderContext hrc) {
        super(hrc);
    }

    @Override
    protected void ensureDisplayed_onRendThrd(CTE estim, float timePerFrame) {
        Set<ThingEstimate> subEstims = ((CompoundEstimate)((Object)estim)).getSubEstimates();
        for (ThingEstimate subEstim : subEstims) {
            EstimateVisualizer subViz = this.getSubVisualizer(subEstim);
            if (subViz == null || !(subViz instanceof BaseVisualizer)) continue;
            ((BaseVisualizer)subViz).ensureDisplayed_onRendThrd(subEstim, timePerFrame);
        }
    }

    @Override
    protected void updateDisplay_onRendThrd(CTE estim, float timePerFrame) {
        Set<ThingEstimate> subEstims = ((CompoundEstimate)((Object)estim)).getSubEstimates();
        for (ThingEstimate subEstim : subEstims) {
            EstimateVisualizer subViz = this.getSubVisualizer(subEstim);
            if (subViz == null || !(subViz instanceof BaseVisualizer)) continue;
            ((BaseVisualizer)subViz).updateDisplay_onRendThrd(subEstim, timePerFrame);
        }
    }

    public EstimateVisualizer getSubVisualizer(ThingEstimate subEstimate) {
        SingleShapeVisualizer subViz = this.mySubVizMap.get((Object)subEstimate);
        if (subViz == null) {
            this.getLogger().info("Making sub-visualizer for {}", (Object)subEstimate);
            VizShapeSiblingGroup existingGroup = this.getShapeGroup();
            subViz = new SingleShapeVisualizer(this, existingGroup);
            this.mySubVizMap.put(subEstimate, subViz);
        }
        return subViz;
    }
}

