/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.migccmio;

import org.appdapter.core.log.BasicDebugger;
import org.cogchar.bind.midi.general.FunMidiEventRouter;
import org.cogchar.bind.midi.in.CCParamRouter;
import org.cogchar.bind.midi.in.InterestingMidiEvent;
import org.cogchar.bind.midi.in.MidiEventReporter;
import org.cogchar.bind.midi.out.DemoMidiOutputPlayer;
import org.cogchar.bind.midi.out.NovLpadTest;
import org.cogchar.bind.midi.out.Switcheroo;
import org.friendularity.api.west.WorldEstimate;
import org.friendularity.migccmio.Mig_WorldEstimateRenderModule;

public class Mig_DemoMidiCommandMapper
extends BasicDebugger
implements MidiEventReporter.Listener {
    public Mig_WorldEstimateRenderModule myWERM;
    public FunMidiEventRouter myFMER = new FunMidiEventRouter();
    public NovLpadTest myNLT = new NovLpadTest();
    public DemoMidiOutputPlayer myDMOP = new DemoMidiOutputPlayer();
    public Switcheroo mySwitcheroo;
    public CCParamRouter myCCPR;

    public void reportEvent(InterestingMidiEvent ime) {
        try {
            WorldEstimate we;
            if (this.mySwitcheroo != null) {
                this.mySwitcheroo.reportEvent(ime);
            }
            if (this.myWERM != null && (we = this.myWERM.getWorldEstimate()) != null) {
                if (ime instanceof InterestingMidiEvent.NoteOn) {
                    InterestingMidiEvent.NoteOn noteOn = (InterestingMidiEvent.NoteOn)ime;
                    this.getLogger().info("Got noteOn: {}", (Object)noteOn);
                }
                if (ime instanceof InterestingMidiEvent.ControlChange) {
                    InterestingMidiEvent.ControlChange cchg = (InterestingMidiEvent.ControlChange)ime;
                    double mult = (float)cchg.myValue / 32.0f;
                    this.getLogger().debug("Setting multA to {}", (Object)mult);
                    we.mult_A = mult;
                }
            }
        }
        catch (Throwable t) {
            this.getLogger().error("Error during midi-mapping", t);
        }
    }

    public void cleanup() {
    }

    protected void startMidiRouters() {
        this.myFMER.registerListener((MidiEventReporter.Listener)this);
        this.myFMER.startPumpingMidiEvents();
        this.myCCPR = new CCParamRouter(this.myFMER);
    }

    public void setWERM(Mig_WorldEstimateRenderModule werm) {
        this.myWERM = werm;
    }

    protected void startMidiOutputDemo() {
        int previewMsec = 2000;
        this.getLogger().info("Temporarily skipping MIDI output demo, which needs to be started asynchronously instead!");
    }

    protected void startMidiSwitcherooDemo() {
        this.mySwitcheroo = new Switcheroo();
        this.mySwitcheroo.myDMOP = this.myDMOP;
        boolean lpadOK = this.myNLT.startLightDemo();
        if (lpadOK) {
            this.mySwitcheroo.myNLT = this.myNLT;
        }
    }

    public static class MidiLaunchWrapper {
        private boolean myFlag_connectMidiIn = true;
        private boolean myFlag_connectMidiOut = true;
        private boolean myFlag_connectMidiSwitcheroo = true;
        private Mig_DemoMidiCommandMapper myMidiMapper;

        public Mig_DemoMidiCommandMapper initMapperWithFeatures() {
            if (this.myMidiMapper == null) {
                this.myMidiMapper = new Mig_DemoMidiCommandMapper();
                if (this.myFlag_connectMidiIn) {
                    this.myMidiMapper.startMidiRouters();
                }
                if (this.myFlag_connectMidiOut) {
                    this.myMidiMapper.startMidiOutputDemo();
                }
                if (this.myFlag_connectMidiSwitcheroo) {
                    this.myMidiMapper.startMidiSwitcherooDemo();
                }
            }
            return this.myMidiMapper;
        }
    }
}

