/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.migccmio;

import org.cogchar.bind.mio.robot.motion.CogcharMotionComputer;
import org.cogchar.bind.mio.robot.motion.CogcharMotionSource;
import org.friendularity.api.west.WorldEstimate;
import org.jflux.api.common.rk.position.NormalizedDouble;
import org.mechio.api.motion.Joint;
import org.mechio.api.motion.Robot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mig_DemoMotionComputer
extends CogcharMotionComputer {
    static Logger theLogger = LoggerFactory.getLogger(Mig_DemoMotionComputer.class);
    long myCycleCount = 0L;
    private WorldEstimate myWorldEstimate;
    int[] sinbadJointNums = new int[]{42, 100, 200, 201, 202, 300, 301, 310, 311, 312, 320, 321, 322, 400, 401, 410, 411, 420, 500, 501, 510, 511, 520, 600, 601, 602, 610, 620, 621, 700, 701, 702, 710, 720, 721};
    static int FULL_CYCLE_LENGTH = 80;
    static float HALF_CYCLE_LENGTH = (float)FULL_CYCLE_LENGTH / 2.0f;
    static int CYCLES_PER_BLOCK = 2;

    public void setWorldEstimate(WorldEstimate we) {
        this.myWorldEstimate = we;
    }

    public void notifySourceComputingCycle(CogcharMotionSource source, long currentTimeUTC, long moveLengthMilliSec) {
        ++this.myCycleCount;
        Robot srcBot = source.getRobot();
        Robot.Id srcBotID = srcBot.getRobotId();
        String robotIdString = srcBotID.getRobtIdString();
        Robot.RobotPositionMap rpm = srcBot.getCurrentPositions();
        if (robotIdString.equals("Sinbad")) {
            int jointCount = this.sinbadJointNums.length;
            long cycleNumber = this.myCycleCount / (long)FULL_CYCLE_LENGTH;
            long phaseStepNumber = this.myCycleCount % (long)FULL_CYCLE_LENGTH;
            double phase_zeroToTwo = (float)phaseStepNumber / HALF_CYCLE_LENGTH;
            double phaseAngleRad = Math.PI * phase_zeroToTwo;
            long blockNumber = (int)(cycleNumber / (long)CYCLES_PER_BLOCK);
            long showStepNumber = cycleNumber % (long)CYCLES_PER_BLOCK;
            long jointIndex = blockNumber % (long)jointCount;
            int someJointNum = this.sinbadJointNums[(int)jointIndex];
            Joint.Id someJointID = new Joint.Id(someJointNum);
            Robot.JointId someRJID = new Robot.JointId(srcBotID, someJointID);
            NormalizedDouble oldJPos = (NormalizedDouble)rpm.get((Object)someRJID);
            NormalizedDouble nextJPos = new NormalizedDouble(0.5 + 0.5 * Math.sin(phaseAngleRad));
            Robot.RobotPositionHashMap goalPosMap = new Robot.RobotPositionHashMap();
            goalPosMap.put((Object)someRJID, (Object)nextJPos);
            source.move((Robot.RobotPositionMap)goalPosMap, moveLengthMilliSec);
            if (phaseStepNumber == 7L && showStepNumber == 0L) {
                theLogger.info("notify[cycle=" + this.myCycleCount + ", currentTime" + currentTimeUTC + ", moveLen=" + moveLengthMilliSec + ", src=" + source + ", botID=" + srcBotID + ", jointID" + someRJID + ", oldJPos=" + oldJPos + ", nextJPos=" + nextJPos + ", curPosMap=" + rpm + "]");
            }
        }
    }

    public void printDeicticWorldVectors() {
    }

    public void sinJoints() {
    }
}

