/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.migccmio;

import com.jme3.scene.Node;
import org.appdapter.core.name.Ident;
import org.appdapter.fancy.rclient.RepoClient;
import org.cogchar.bind.symja.MathGate;
import org.cogchar.render.app.humanoid.HumanoidRenderContext;
import org.cogchar.render.sys.module.RenderGateway;
import org.cogchar.render.sys.module.RenderModule;
import org.cogchar.render.sys.registry.RenderRegistryClient;
import org.friendularity.api.west.WorldEstimate;
import org.friendularity.impl.visual.DemoWorldVisualizer;
import org.friendularity.impl.visual.EstimateVisualizer;
import org.friendularity.migccmio.Mig_DemoMidiCommandMapper;
import org.friendularity.migccmio.SnapMonApi;
import org.friendularity.visual.texture.JVisionTextureMapper;
import org.friendularity.visual.texture.MagicVisionBoxScene;

public abstract class Mig_WorldEstimateRenderModule
extends RenderModule
implements WorldEstimate.Consumer {
    private EstimateVisualizer<WorldEstimate> myWorldEstimVisualizer;
    private MathGate myMathGate;
    private WorldEstimate myCachedWorldEstim;
    boolean myFlag_bonusMeshesNeeded = true;
    private boolean myFlag_JVisionTextureRoutingEnabled = false;
    private MagicVisionBoxScene myMVBS;
    private SnapMonApi mySnapMon;
    private Mig_DemoMidiCommandMapper myMidiMapper;

    public Mig_WorldEstimateRenderModule() {
        this.setDebugRateModulus(1000);
    }

    @Override
    public void setWorldEstimate(WorldEstimate worldEstim) {
        this.myCachedWorldEstim = worldEstim;
    }

    public void setMidiMapper(Mig_DemoMidiCommandMapper midiMapper) {
        this.myMidiMapper = midiMapper;
    }

    public WorldEstimate getWorldEstimate() {
        return this.myCachedWorldEstim;
    }

    public void setMathGate(MathGate mg) {
        this.myMathGate = mg;
    }

    public void setFlag_JVisionTextureRoutingEnabled(boolean flag) {
        this.myFlag_JVisionTextureRoutingEnabled = flag;
    }

    private JVisionTextureMapper setupJVisionConnection() {
        this.getLogger().info("Setup for vision-texture-mappper");
        JVisionTextureMapper jvtm = new JVisionTextureMapper();
        jvtm.connectToImageStreamBroker();
        return jvtm;
    }

    private void setupMagicVisionBoxScene_onRendThrd(RenderRegistryClient rrc, JVisionTextureMapper optJVTM, float tpf) {
        this.getLogger().info("One time setup for Magic Vision Box Scene");
        this.myMVBS = new MagicVisionBoxScene();
        this.myMVBS.setup_onRendThrd(rrc, tpf);
        if (optJVTM != null) {
            this.myMVBS.setJVisionTextureMapper(optJVTM);
        }
    }

    protected abstract SnapMonApi makeSnapMon();

    protected void setupSnapMon(RenderRegistryClient rrc, JVisionTextureMapper optJVTM) {
        Node rootDeepNode = rrc.getJme3RootDeepNode(null);
        this.mySnapMon = this.makeSnapMon();
        this.mySnapMon.setup_onRendThrd(rrc, rootDeepNode);
        this.mySnapMon.setJVisionTextureMapper(optJVTM);
        if (this.myMidiMapper != null && this.myMidiMapper.myCCPR != null) {
            this.mySnapMon.attachMidiCCs(this.myMidiMapper.myCCPR);
        } else {
            this.getLogger().warn("NOT setting up CC-paramRouter mapping to SnapshotMonitor!  midiMapper={}, ccpr={}", (Object)this.myMidiMapper, this.myMidiMapper != null ? this.myMidiMapper.myCCPR : null);
        }
    }

    protected void doRenderCycle(long runSeqNum, float timePerFrame) {
        if (this.myMathGate != null && this.myCachedWorldEstim != null) {
            this.myCachedWorldEstim.updateFromMathSpace(this.myMathGate);
        }
        if (this.myWorldEstimVisualizer != null) {
            if (this.myCachedWorldEstim != null) {
                this.myWorldEstimVisualizer.renderCurrentEstimates_onRendThrd(this.myCachedWorldEstim, timePerFrame);
            }
            if (this.myFlag_bonusMeshesNeeded) {
                this.myFlag_bonusMeshesNeeded = false;
                JVisionTextureMapper optJVTM = null;
                if (this.myFlag_JVisionTextureRoutingEnabled) {
                    optJVTM = this.setupJVisionConnection();
                }
                this.getLogger().info("One time setup for bonus-meshes");
                RenderRegistryClient rrc = this.myWorldEstimVisualizer.getRenderRegistryClient();
                ((DemoWorldVisualizer)this.myWorldEstimVisualizer).makeBonusMeshes();
                if (this.mySnapMon == null) {
                    this.setupSnapMon(rrc, optJVTM);
                }
                if (this.myMVBS == null) {
                    this.setupMagicVisionBoxScene_onRendThrd(rrc, optJVTM, timePerFrame);
                }
            } else {
                if (this.mySnapMon != null) {
                    this.mySnapMon.update_onRendThrd(timePerFrame);
                }
                if (this.myMVBS != null) {
                    this.myMVBS.update_onRendThrd(timePerFrame);
                }
            }
        }
    }

    public EstimateVisualizer setupVisualizer(RepoClient rc, Ident charID, Ident vizConfGraphID) {
        DemoWorldVisualizer viz;
        this.getLogger().info("Setting up visualizer for char {} with confGraph {}", (Object)charID, (Object)vizConfGraphID);
        RenderGateway rg = this.getRenderGateway();
        HumanoidRenderContext hrc = (HumanoidRenderContext)rg.getCogcharRenderContext();
        this.myWorldEstimVisualizer = viz = new DemoWorldVisualizer(hrc);
        return viz;
    }
}

