/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.tmpgood.tgbit;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.shape.Cylinder;
import com.jme3.scene.shape.Torus;
import org.appdapter.core.name.Ident;
import org.cogchar.render.goody.basic.BasicGoodyCtx;
import org.cogchar.render.sys.task.Queuer;
import org.friendularity.tmpgood.tgbit.TG_AbstractBitGoody;

public class TG_BitBox
extends TG_AbstractBitGoody {
    private static final ColorRGBA FALSE_COLOR = ColorRGBA.Blue;
    private static final ColorRGBA TRUE_COLOR = ColorRGBA.Red;
    private int zeroIndex;
    private int oneIndex;

    public TG_BitBox(BasicGoodyCtx bgc, Ident boxUri, Vector3f initialPosition, Quaternion initialRotation, Vector3f size, boolean boxState) {
        super(bgc, boxUri);
        Queuer.QueueingStyle qStyle = Queuer.QueueingStyle.QUEUE_AND_RETURN;
        if (size == null) {
            this.getLogger().warn("No size specified for BitBox, defaulting to size = 1");
            size = new Vector3f(1.0f, 1.0f, 1.0f);
        } else if (Math.abs(size.length() - 0.0f) < 0.001f) {
            this.getLogger().warn("BitBox being created with zero size!");
        }
        this.setPositionAndRotation(initialPosition, initialRotation, qStyle);
        this.setVectorScale(size, qStyle);
        Torus zeroMesh = new Torus(40, 20, 0.2f, 0.8333333f);
        Cylinder oneMesh = new Cylinder(20, 20, 0.2f, 2.0f, true);
        this.zeroIndex = this.addGeometry((Mesh)zeroMesh, FALSE_COLOR);
        float[] oneRotationAngles = new float[]{1.5707964f, 0.0f, 0.0f};
        this.oneIndex = this.addGeometry((Mesh)oneMesh, TRUE_COLOR, new Quaternion(oneRotationAngles));
        this.state = boxState;
    }

    public void attachToVirtualWorldNode(Node rootNode, Queuer.QueueingStyle qStyle) {
        this.attachToVirtualWorldNode(rootNode, this.state ? this.oneIndex : this.zeroIndex, qStyle);
    }

    public void attachToVirtualWorldNode(Node rootNode, boolean boxState, Queuer.QueueingStyle qStyle) {
        this.state = boxState;
        this.attachToVirtualWorldNode(rootNode, qStyle);
    }

    @Override
    public void setState(boolean boxState, Queuer.QueueingStyle qStyle) {
        int geometryIndex = boxState ? this.oneIndex : this.zeroIndex;
        this.setGeometryByIndex(geometryIndex, qStyle);
        this.state = boxState;
    }
}

