/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.tmpgood.tgbit;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.texture.Texture;
import jme3tools.optimize.TextureAtlas;
import org.appdapter.core.name.Ident;
import org.cogchar.render.goody.basic.BasicGoodyCtx;
import org.cogchar.render.opengl.optic.MatFactory;
import org.cogchar.render.sys.task.Queuer;
import org.friendularity.tmpgood.tgbit.TG_AbstractBitGoody;
import org.friendularity.tmpgood.tgbit.TG_BitCubeBox;

public class TG_BitCube
extends TG_AbstractBitGoody {
    private static final float STATE_TRANSITION_TIME = 2.0f;
    private int geomIndex;

    public TG_BitCube(BasicGoodyCtx bgc, Ident boxUri, Vector3f initialPosition, Quaternion initialRotation, Vector3f size, Boolean boxState) {
        super(bgc, boxUri);
        Queuer.QueueingStyle qStyle = Queuer.QueueingStyle.QUEUE_AND_RETURN;
        if (size == null) {
            this.getLogger().warn("No size specified for BitCube, defaulting to size = 1");
            size = new Vector3f(1.0f, 1.0f, 1.0f);
        } else if (Math.abs(size.length() - 0.0f) < 0.001f) {
            this.getLogger().warn("BitCube being created with zero size!");
        }
        this.setPositionAndRotation(initialPosition, initialRotation, qStyle);
        this.setVectorScale(size, qStyle);
        this.geomIndex = this.addCubeGeometry();
        this.state = boxState;
        this.setNewGeometryRotationOffset(this.geomIndex, this.getStateAdjustedRotationOffset(boxState));
    }

    private int addCubeGeometry() {
        TG_BitCubeBox cubeMesh = new TG_BitCubeBox(1.0f, 1.0f, 1.0f);
        TextureAtlas atlas = new TextureAtlas(400, 1200);
        MatFactory matFact = this.getRenderRegCli().getOpticMaterialFacade(null, null);
        AssetManager assetMgr = matFact.getAssetManager();
        Texture zeroTexture = assetMgr.loadTexture("textures/robosteps/Zero.png");
        Texture oneTexture = assetMgr.loadTexture("textures/robosteps/One.png");
        Texture blankTexture = assetMgr.loadTexture("textures/robosteps/BlankGray.png");
        atlas.addTexture(zeroTexture, "ColorMap");
        atlas.addTexture(oneTexture, "ColorMap");
        atlas.addTexture(blankTexture, "ColorMap");
        Material cubeMaterial = matFact.makeMatWithOptTexture("Common/MatDefs/Misc/Unshaded.j3md", "ColorMap", atlas.getAtlasTexture("ColorMap"));
        return this.addGeometry((Mesh)cubeMesh, cubeMaterial, null, new Quaternion());
    }

    private Quaternion getStateAdjustedRotationOffset(boolean boxState) {
        float yaw = boxState ? (float)Math.PI : 0.0f;
        return new Quaternion().fromAngles(0.0f, yaw, 0.0f);
    }

    @Override
    public void setState(boolean boxState, Queuer.QueueingStyle qStyle) {
        if (boxState != this.state) {
            Quaternion initialRotation = this.getRotation();
            Vector3f position = this.getPosition();
            Vector3f scale = this.getScale();
            this.moveViaAnimation(position, initialRotation.mult(new Quaternion().fromAngles(0.0f, (float)Math.PI, 0.0f)), scale, 2.0f);
            this.setNewGeometryRotationOffset(this.geomIndex, this.getStateAdjustedRotationOffset(boxState));
            this.setRotation(initialRotation, qStyle);
            this.state = boxState;
        }
    }
}

