/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.tmpgood.tgflat;

import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import java.awt.Dimension;
import org.appdapter.core.name.Ident;
import org.cogchar.render.goody.basic.BasicGoodyCtx;
import org.cogchar.render.sys.task.Queuer;
import org.friendularity.tmpgood.tgflat.TG_FlatGoodyTextElement;
import org.friendularity.tmpgood.tgflat.TG_FlatGoodyWithScreenFracPos;

public class TG_CrossHairGoody
extends TG_FlatGoodyWithScreenFracPos {
    BitmapText myNode;
    TG_FlatGoodyTextElement myTextEl;

    public TG_CrossHairGoody(BasicGoodyCtx bgc, Ident uri, Vector3f positionOffset, Float scale) {
        super(bgc, uri);
        this.myTextEl = new TG_FlatGoodyTextElement(bgc.getRRC());
        this.makeCrossHairs(scale, positionOffset);
    }

    private void makeCrossHairs(Float scale, Vector3f position) {
        if (scale == null) {
            scale = Float.valueOf(1.0f);
            this.getLogger().warn("Scale for CrossHair not specified; using default of 1.");
        }
        this.myTextEl.setContentText("+");
        this.myTextEl.setUniformScaleFactor(scale, Queuer.QueueingStyle.QUEUE_AND_RETURN);
        this.myNode = this.myTextEl.getTextNode();
        BitmapFont bf = this.myNode.getFont();
        Dimension screenDim = this.getScreenDim();
        float crossHalfWidthFraction = (float)bf.getCharSet().getRenderedSize() / 3.0f * 2.0f / (float)screenDim.width;
        float crossHalfHeightFraction = this.myNode.getLineHeight() / 2.0f / (float)screenDim.height;
        Vector3f relativePosition = new Vector3f(-crossHalfWidthFraction, crossHalfHeightFraction, 0.0f);
        if (position == null || position.getX() == 0.0f && position.getY() == 0.0f) {
            position = new Vector3f(0.5f, 0.5f, 0.0f);
        }
        this.setPosition(position.add(relativePosition), Queuer.QueueingStyle.QUEUE_AND_RETURN);
    }

    @Override
    protected Node getFlatGoodyNode() {
        return this.myNode;
    }
}

