/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.tmpgood.tgflat;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.concurrent.Callable;
import org.appdapter.core.name.Ident;
import org.cogchar.render.app.entity.GoodyActionExtractor;
import org.cogchar.render.goody.basic.BasicGoodyCtx;
import org.cogchar.render.goody.basic.BasicVWorldEntity;
import org.cogchar.render.opengl.scene.FlatOverlayMgr;
import org.cogchar.render.sys.task.Queuer;

public abstract class TG_FlatGoody
extends BasicVWorldEntity {
    private FlatOverlayMgr myOverlayMgr;
    private ColorRGBA myForeColor;

    protected TG_FlatGoody(BasicGoodyCtx bgc, Ident uri) {
        super(bgc, uri);
        this.myOverlayMgr = bgc.getRRC().getSceneFlatFacade(null);
    }

    protected abstract Node getFlatGoodyNode();

    public void attachToVirtualWorldNode(Node vWorldNode, Queuer.QueueingStyle qStyle) {
        this.attachToOverlaySpatial(qStyle);
    }

    protected void attachToOverlaySpatial(Queuer.QueueingStyle style) {
        final Node fgn = this.getFlatGoodyNode();
        if (fgn != null) {
            this.enqueueForJme(new Callable(){

                public Void call() throws Exception {
                    TG_FlatGoody.this.getLogger().debug("Attaching 2d goody to virtual world: name={}, location={}, gnode={}", new Object[]{TG_FlatGoody.this.getUri().getLocalName(), fgn.getLocalTranslation(), fgn});
                    TG_FlatGoody.this.myOverlayMgr.attachOverlaySpatial((Spatial)fgn);
                    return null;
                }
            }, style);
        } else {
            this.getLogger().warn("Attempting to attach 2D Goody {} to virtual world, but no FlatGoody Node was found", (Object)this.getUri().getLocalName());
        }
    }

    public void detachFromVirtualWorldNode(Queuer.QueueingStyle style) {
        final Node fgn = this.getFlatGoodyNode();
        this.enqueueForJme(new Callable(){

            public Void call() throws Exception {
                TG_FlatGoody.this.myOverlayMgr.detachOverlaySpatial((Spatial)fgn);
                return null;
            }
        }, style);
    }

    protected void setScreenPosition(final Vector3f screenPos, Queuer.QueueingStyle qStyle) {
        final Node fgn = this.getFlatGoodyNode();
        if (fgn != null) {
            Callable positioningCallable = new Callable(){

                public Void call() throws Exception {
                    TG_FlatGoody.this.getLogger().debug("Setting screen position for {} to {}", (Object)TG_FlatGoody.this.getUri().getLocalName(), (Object)screenPos);
                    fgn.setLocalTranslation(screenPos);
                    return null;
                }
            };
            this.enqueueForJme(positioningCallable, qStyle);
        }
    }

    public void applyAction(GoodyActionExtractor ga, Queuer.QueueingStyle qStyle) {
        switch (ga.getKind()) {
            case MOVE: 
            case SET: {
                Vector3f locVec = ga.getLocationVec3f();
                if (locVec != null) {
                    this.setScreenPosition(locVec, qStyle);
                }
                this.setUniformScaleFactor(ga.getScaleUniform(), qStyle);
                break;
            }
            default: {
                this.getLogger().error("Unknown action requested in Goody {}: {}", (Object)this.getUri().getLocalName(), (Object)ga.getKind().name());
            }
        }
    }

    public void setPosition(Vector3f position, Queuer.QueueingStyle style) {
        this.setScreenPosition(position, style);
    }
}

