/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.tmpgood.tgflat;

import com.jme3.font.BitmapText;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import org.appdapter.core.log.BasicDebugger;
import org.cogchar.render.sys.registry.RenderRegistryClient;
import org.cogchar.render.sys.task.Queuer;

public class TG_FlatGoodyTextElement
extends BasicDebugger {
    private Vector3f myScreenPosRelToParent = new Vector3f();
    private BitmapText myOverlayText;
    private RenderRegistryClient myRenderRegCli;
    private float myScale = 1.0f;
    private ColorRGBA myColor;
    private String myContent = "No Content Set";

    public TG_FlatGoodyTextElement(RenderRegistryClient aRenderRegCli) {
        this.myRenderRegCli = aRenderRegCli;
    }

    public void setScreenPosRelToParent(Vector3f sprtp, Queuer.QueueingStyle qStyle) {
        this.myScreenPosRelToParent = sprtp;
    }

    public void setContentText(String goodyText) {
        this.myContent = goodyText;
        if (this.myOverlayText != null) {
            this.myOverlayText.setText(goodyText);
        }
    }

    public void setUniformScaleFactor(Float scale, Queuer.QueueingStyle qStyle) {
        this.getLogger().debug("Setting 2d Goody scale to {}", (Object)scale);
        if (scale != null) {
            this.myScale = scale.floatValue();
            if (this.myOverlayText != null) {
                this.myOverlayText.setSize((float)this.myOverlayText.getFont().getCharSet().getRenderedSize() * scale.floatValue());
            }
        }
    }

    public void setColor(ColorRGBA color) {
        if (color != null) {
            this.myColor = color;
            if (this.myOverlayText != null) {
                this.myOverlayText.setColor(color);
            }
        }
    }

    public BitmapText getTextNode() {
        if (this.myOverlayText == null) {
            this.myOverlayText = this.myRenderRegCli.getSceneTextFacade(null).getScaledBitmapText(this.myContent, this.myScale);
        }
        return this.myOverlayText;
    }
}

