/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.tmpgood.tgflat;

import com.jme3.math.Vector3f;
import java.awt.Dimension;
import org.appdapter.core.name.Ident;
import org.cogchar.render.goody.basic.BasicGoodyCtx;
import org.cogchar.render.sys.task.Queuer;
import org.friendularity.tmpgood.tgflat.TG_FlatGoody;

public abstract class TG_FlatGoodyWithScreenFracPos
extends TG_FlatGoody {
    private Dimension myStoredScreenDim;
    private float myFracPosX = 0.5f;
    private float myFracPosY = 0.5f;

    protected TG_FlatGoodyWithScreenFracPos(BasicGoodyCtx bgc, Ident uri) {
        super(bgc, uri);
        Dimension screenDimension = bgc.getScreenDimension();
        if (screenDimension != null) {
            this.applyScreenDimension(screenDimension);
        } else {
            this.getLogger().warn("Cannot find screen dimension.");
        }
    }

    protected void refreshScreenPos(Queuer.QueueingStyle qStyle) {
        Dimension sDim = this.getScreenDim();
        Vector3f nextAbsPos = new Vector3f((float)sDim.width * this.myFracPosX, (float)sDim.height * this.myFracPosY, 0.0f);
        this.setScreenPosition(nextAbsPos, qStyle);
    }

    public final void applyScreenDimension(Dimension screenDimension) {
        this.myStoredScreenDim = screenDimension;
        this.refreshScreenPos(Queuer.QueueingStyle.QUEUE_AND_RETURN);
    }

    protected Dimension getScreenDim() {
        if (this.myStoredScreenDim == null) {
            this.myStoredScreenDim = new Dimension(640, 480);
        }
        return this.myStoredScreenDim;
    }

    public void setFractionalPosition(float fracPosX, float fracPosY, Queuer.QueueingStyle qStyle) {
        this.getLogger().debug("Setting fracPosition: {},{}", (Object)Float.valueOf(fracPosX), (Object)Float.valueOf(fracPosY));
        this.myFracPosX = fracPosX;
        this.myFracPosY = fracPosY;
        this.refreshScreenPos(qStyle);
    }
}

