/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.tmpgood.tgflat;

import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.font.Rectangle;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.List;
import org.friendularity.tmpgood.tgflat.TG_GeneralScoreBoard;

public class TG_ScoreBoard
implements TG_GeneralScoreBoard {
    Node myParentNode;
    BitmapFont myLabelFont;
    BitmapFont myScoreFont;
    ColorRGBA myScoreColor;
    int myBaseX;
    int myBaseY;
    int myWidth;
    int myHeight;
    List<Row> myRows = new ArrayList<Row>();

    public TG_ScoreBoard(AssetManager assetManager, Node parentNode, int baseX, int baseY, int boardWidth, int rowHeight, int numRows, float textSizeMult) {
        this.myScoreFont = assetManager.loadFont("Interface/Fonts/Default.fnt");
        this.myScoreColor = ColorRGBA.Magenta;
        int topY = baseY + (numRows - 1) * rowHeight;
        for (int rowIdx = 0; rowIdx < numRows; ++rowIdx) {
            Row aLine = new Row(baseX, topY - rowIdx * rowHeight, boardWidth, rowHeight, textSizeMult);
            parentNode.attachChild(aLine.getRenderingSpatial());
            this.myRows.add(aLine);
            aLine.setScoreText("line_" + rowIdx);
        }
    }

    @Override
    public void displayScore(int rowNum, String scoreText) {
        Row l = this.myRows.get(rowNum);
        l.setScoreText(scoreText);
    }

    public class Row {
        private BitmapText myRenderedText;
        private Rectangle myRectangle;

        public Row(int baseX, int baseY, int width, int height, float textSizeMult) {
            this.myRenderedText = new BitmapText(TG_ScoreBoard.this.myScoreFont, false);
            float scoreFontSize = TG_ScoreBoard.this.myScoreFont.getPreferredSize();
            this.myRenderedText.setSize(scoreFontSize * textSizeMult);
            this.myRenderedText.setText("_");
            this.myRenderedText.setLocalTranslation((float)baseX, (float)(baseY + height), 0.0f);
            this.myRenderedText.setColor(TG_ScoreBoard.this.myScoreColor);
        }

        Spatial getRenderingSpatial() {
            return this.myRenderedText;
        }

        public void setScoreText(String scoreText) {
            this.myRenderedText.setText(scoreText);
        }
    }
}

