/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.tmpgood.tgflat;

import com.jme3.font.BitmapText;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.List;
import org.appdapter.core.name.FreeIdent;
import org.appdapter.core.name.Ident;
import org.cogchar.name.goody.GoodyNames;
import org.cogchar.render.app.entity.GoodyActionExtractor;
import org.cogchar.render.goody.basic.BasicGoodyCtx;
import org.cogchar.render.sys.registry.RenderRegistryClient;
import org.cogchar.render.sys.task.Queuer;
import org.friendularity.tmpgood.tgflat.TG_FlatGoody;
import org.friendularity.tmpgood.tgflat.TG_FlatGoodyTextElement;
import org.friendularity.tmpgood.tgflat.TG_GeneralScoreBoard;

public class TG_ScoreBoardGoody
extends TG_FlatGoody
implements TG_GeneralScoreBoard {
    static final ColorRGBA MY_SCORE_COLOR = ColorRGBA.Magenta;
    float myRowHeight;
    Vector3f myPosition;
    List<Row> myRows;
    private Node myNode;

    public TG_ScoreBoardGoody(BasicGoodyCtx bgc, Ident uri, Vector3f topPosition, float rowHeight, int numRows, float textSize) {
        super(bgc, uri);
        this.myNode = new Node("ScoreBoardGoody_" + uri.getLocalName());
        this.myRows = new ArrayList<Row>();
        this.myRowHeight = rowHeight;
        String baseUriString = uri.getAbsUriString();
        RenderRegistryClient grrc = bgc.getRRC();
        for (int rowIdx = 0; rowIdx < numRows; ++rowIdx) {
            FreeIdent rowIdent = new FreeIdent(baseUriString + "Row" + rowIdx);
            Row aLine = new Row(grrc, (Ident)rowIdent, this.getPositionForRow(rowIdx, topPosition), textSize, MY_SCORE_COLOR);
            this.myRows.add(aLine);
            aLine.setScoreText("line_" + rowIdx);
            BitmapText rowTextNode = aLine.getTextNode();
            this.myNode.attachChild((Spatial)rowTextNode);
        }
        this.setPosition(topPosition, Queuer.QueueingStyle.QUEUE_AND_RETURN);
    }

    @Override
    protected Node getFlatGoodyNode() {
        return this.myNode;
    }

    @Override
    public void displayScore(int rowNum, String scoreText) {
        if (rowNum >= 0 && rowNum < this.myRows.size()) {
            Row l = this.myRows.get(rowNum);
            l.setScoreText(scoreText);
        } else {
            this.getLogger().warn("A request was made to set text for Scoreboard row #{}, but that row does not exist!", (Object)rowNum);
        }
    }

    @Override
    public void applyAction(GoodyActionExtractor ga, Queuer.QueueingStyle qStyle) {
        switch (ga.getKind()) {
            case MOVE: {
                this.setPosition(ga.getLocationVec3f(), qStyle);
                break;
            }
            case SET: {
                String scoreText = ga.getSpecialString(GoodyNames.TEXT);
                int rowNum = 0;
                try {
                    rowNum = Integer.valueOf(ga.getSpecialString(GoodyNames.SUBCOMPONENT));
                }
                catch (Exception e) {
                    this.getLogger().error("Row (subcomponent) number not recognized for setting scoreboard, assuming 0");
                }
                this.displayScore(rowNum, scoreText);
                break;
            }
            default: {
                this.getLogger().error("Unknown action requested in Goody {}: {}", (Object)this.getUri().getLocalName(), (Object)ga.getKind().name());
            }
        }
    }

    @Override
    public void setPosition(Vector3f position, Queuer.QueueingStyle qStyle) {
        super.setPosition(position, qStyle);
        for (int rowIdx = 0; rowIdx < this.myRows.size(); ++rowIdx) {
            Row nextRow = this.myRows.get(rowIdx);
            nextRow.setScreenPosRelToParent(this.getPositionForRow(rowIdx, position), qStyle);
        }
        this.myPosition = position;
    }

    public void setUniformScaleFactor(Float scale, Queuer.QueueingStyle qStyle) {
        this.getLogger().warn("Setting scale not currently implemented for the ScoreBoardGoody, coming soon...");
    }

    private Vector3f getPositionForRow(int row, Vector3f scoreboardPosition) {
        float leftX = scoreboardPosition.getX();
        float topY = scoreboardPosition.getY() - (float)row * this.myRowHeight;
        return new Vector3f(leftX, topY, 0.0f);
    }

    public void setRotation(Quaternion newRotation, Queuer.QueueingStyle qStyle) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public class Row
    extends TG_FlatGoodyTextElement {
        public Row(RenderRegistryClient aRenderRegCli, Ident uri, Vector3f rowPosition, float textSize, ColorRGBA scoreColor) {
            super(aRenderRegCli);
            this.setScreenPosRelToParent(rowPosition, Queuer.QueueingStyle.QUEUE_AND_RETURN);
            this.setContentText("_");
            this.setUniformScaleFactor(Float.valueOf(textSize), Queuer.QueueingStyle.QUEUE_AND_RETURN);
            this.setColor(scoreColor);
        }

        public void setScoreText(String scoreText) {
            this.setContentText(scoreText);
        }
    }
}

