/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.tmpgood.tgtic;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.shape.Cylinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.appdapter.core.name.FreeIdent;
import org.appdapter.core.name.Ident;
import org.cogchar.name.goody.GoodyNames;
import org.cogchar.render.app.entity.GoodyActionExtractor;
import org.cogchar.render.app.entity.VWorldEntity;
import org.cogchar.render.goody.basic.BasicGoodyCtx;
import org.cogchar.render.goody.basic.BasicGoodyEntity;
import org.cogchar.render.goody.basic.CompositeMeshBuilder;
import org.cogchar.render.sys.task.Queuer;
import org.friendularity.tmpgood.tgtic.TG_TicTacMark;

public class TG_TicTacGrid
extends BasicGoodyEntity {
    private static final ColorRGBA DEFAULT_GRID_COLOR = ColorRGBA.Blue;
    private static final float SIZE_MULTIPLIER = 9.0f;
    private static final float[] ROTATE_UPRIGHT = new float[]{1.5707964f, 0.0f, 0.0f};
    public static final Ident CLEAR_IDENT = GoodyNames.makeID((String)"clearMarks");
    private Map<Ident, TG_TicTacMark> markMap = new HashMap<Ident, TG_TicTacMark>();

    public TG_TicTacGrid(BasicGoodyCtx bgc, Ident boxUri, Vector3f initialPosition, Quaternion initialRotation, ColorRGBA color, Vector3f size) {
        super(bgc, boxUri);
        this.setPositionRotationAndScale(initialPosition, initialRotation, size, Queuer.QueueingStyle.QUEUE_AND_RETURN);
        Mesh gridMesh = this.makeCustomGridMesh();
        if (color == null) {
            color = DEFAULT_GRID_COLOR;
        }
        this.addGeometry(gridMesh, color, new Quaternion(ROTATE_UPRIGHT));
    }

    private Mesh makeCustomGridMesh() {
        Cylinder gridLeg = new Cylinder(20, 20, 0.2f, 9.0f, true);
        float offsetDistance = 1.5f;
        ArrayList<CompositeMeshBuilder.MeshComponent> meshComponents = new ArrayList<CompositeMeshBuilder.MeshComponent>();
        meshComponents.add(new CompositeMeshBuilder.MeshComponent((Mesh)gridLeg, new Vector3f(offsetDistance, 0.0f, 0.0f)));
        meshComponents.add(new CompositeMeshBuilder.MeshComponent((Mesh)gridLeg, new Vector3f(-offsetDistance, 0.0f, 0.0f)));
        Quaternion rotate90DegAroundY = new Quaternion();
        rotate90DegAroundY.fromAngleAxis(1.5707964f, new Vector3f(0.0f, 1.0f, 0.0f));
        meshComponents.add(new CompositeMeshBuilder.MeshComponent((Mesh)gridLeg, rotate90DegAroundY, new Vector3f(0.0f, 0.0f, offsetDistance)));
        meshComponents.add(new CompositeMeshBuilder.MeshComponent((Mesh)gridLeg, rotate90DegAroundY, new Vector3f(0.0f, 0.0f, -offsetDistance)));
        CompositeMeshBuilder builder = new CompositeMeshBuilder();
        return builder.makeCompositeMesh(meshComponents);
    }

    public void addMarkAt(int xPos, int yPos, boolean isPlayerO) {
        Ident markUri = this.createMarkIdent(xPos, yPos);
        if (xPos < 1 || xPos > 3 || yPos < 1 || yPos > 3) {
            this.getLogger().error("Can't add TicTacMark to grid; position of ({}, {}) is invalid", (Object)xPos, (Object)yPos);
        } else if (this.markMap.containsKey(markUri)) {
            this.getLogger().warn("Can't add TicTacMark to grid; there is already a mark at position ({}, {})", (Object)xPos, (Object)yPos);
        } else {
            Vector3f markPosition = this.getWorldPositionForMark(xPos, yPos);
            Quaternion rotation = this.getRotation();
            Vector3f scale = this.getScale();
            BasicGoodyCtx bgc = this.getGoodyCtx();
            TG_TicTacMark markGoody = new TG_TicTacMark(bgc, markUri, markPosition, rotation, scale, isPlayerO);
            bgc.getVWER().addGoody((VWorldEntity)markGoody);
            Node parentNode = this.getParentNode();
            markGoody.attachToVirtualWorldNode(parentNode, Queuer.QueueingStyle.QUEUE_AND_RETURN);
            this.markMap.put(markUri, markGoody);
        }
    }

    public void removeMark(int xPos, int yPos) {
        Ident markIdent = this.createMarkIdent(xPos, yPos);
        BasicGoodyEntity markToRemove = this.markMap.get(markIdent);
        if (markToRemove != null) {
            this.getGoodyCtx().getVWER().removeGoody((VWorldEntity)markToRemove);
            this.markMap.remove(markIdent);
        } else {
            this.getLogger().warn("No TicTacMark to remove at location ({}, {})", (Object)xPos, (Object)yPos);
        }
    }

    public void clearMarks() {
        for (BasicGoodyEntity basicGoodyEntity : this.markMap.values()) {
            this.getGoodyCtx().getVWER().removeGoody((VWorldEntity)basicGoodyEntity);
        }
        this.markMap.clear();
    }

    private Ident createMarkIdent(int xPos, int yPos) {
        String uriString = this.getUri().getAbsUriString();
        uriString = uriString + "Mark" + xPos + yPos;
        return new FreeIdent(uriString);
    }

    private int[] getGridPosition(Ident markIdent) {
        String markName = markIdent.getLocalName();
        int xPos = Integer.valueOf(String.valueOf(markName.charAt(markName.length() - 2)));
        int yPos = Integer.valueOf(String.valueOf(markName.charAt(markName.length() - 1)));
        return new int[]{xPos, yPos};
    }

    private Vector3f getWorldPositionForMark(int xPos, int yPos) {
        Quaternion rotation = this.getRotation();
        Vector3f scale = this.getScale();
        Vector3f position = this.getPosition();
        float markOffsetX = 9.0f * scale.getX() / 3.0f;
        float markOffsetY = 9.0f * scale.getY() / 3.0f;
        Vector3f relativeMarkPosition = new Vector3f(markOffsetX * (float)(xPos - 2), -markOffsetY * (float)(yPos - 2), 0.0f);
        relativeMarkPosition = rotation.mult(relativeMarkPosition);
        return position.add(relativeMarkPosition);
    }

    private Vector3f getWorldPositionForMark(TG_TicTacMark mark) {
        int[] gridPosition = this.getGridPosition(mark.getUri());
        return this.getWorldPositionForMark(gridPosition[0], gridPosition[1]);
    }

    public void detachFromVirtualWorldNode(Queuer.QueueingStyle qStyle) {
        this.clearMarks();
        super.detachFromVirtualWorldNode(qStyle);
    }

    public void setPositionAndRotation(Vector3f newPosition, Quaternion newRotation, Queuer.QueueingStyle qStyle) {
        Vector3f scale = this.getScale();
        this.setPositionRotationAndScale(newPosition, newRotation, scale, qStyle);
    }

    public void setUniformScaleFactor(Float newScale, Queuer.QueueingStyle qStyle) {
        this.setVectorScale(new Vector3f(newScale.floatValue(), newScale.floatValue(), newScale.floatValue()), qStyle);
    }

    public void setVectorScale(Vector3f newScale, Queuer.QueueingStyle qStyle) {
        Quaternion rotation = this.getRotation();
        Vector3f position = this.getPosition();
        this.setPositionRotationAndScale(position, rotation, newScale, qStyle);
    }

    public final void setPositionRotationAndScale(Vector3f newPosition, Quaternion newRotation, Vector3f newScale, Queuer.QueueingStyle qStyle) {
        super.setPositionAndRotation(newPosition, newRotation, qStyle);
        super.setVectorScale(newScale, qStyle);
        for (TG_TicTacMark markGoody : this.markMap.values()) {
            markGoody.setVectorScale(newScale, qStyle);
            markGoody.setPositionAndRotation(this.getWorldPositionForMark(markGoody), newRotation, qStyle);
        }
    }

    protected void moveViaAnimation(Vector3f newPosition, Quaternion newOrientation, Vector3f newScale, float duration) {
        this.getLogger().warn("MOVE not yet supported for TicTacGrid, coming soon...");
    }

    public void applyAction(GoodyActionExtractor ga, Queuer.QueueingStyle qStyle) {
        super.applyAction(ga, qStyle);
        switch (ga.getKind()) {
            case SET: {
                Boolean clearMarksFlag = ga.getSpecialBoolean(CLEAR_IDENT);
                Boolean stateFlag = ga.getSpecialBoolean(GoodyNames.USE_O);
                if (clearMarksFlag != null && clearMarksFlag.booleanValue()) {
                    try {
                        if (!Boolean.valueOf(clearMarksFlag).booleanValue()) break;
                        this.clearMarks();
                    }
                    catch (Exception e) {}
                    break;
                }
                if (stateFlag == null) break;
                try {
                    int xCoord = ga.getSpecialInteger(GoodyNames.COORDINATE_X);
                    int yCoord = ga.getSpecialInteger(GoodyNames.COORDINATE_Y);
                    this.addMarkAt(xCoord, yCoord, stateFlag);
                }
                catch (Exception e) {
                    this.getLogger().error("Error interpreting parameters for adding mark to TicTacGrid", (Throwable)e);
                }
                break;
            }
        }
    }
}

