/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.tmpgood.tgtic;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.shape.Cylinder;
import com.jme3.scene.shape.Torus;
import java.util.ArrayList;
import org.appdapter.core.name.Ident;
import org.cogchar.name.goody.GoodyNames;
import org.cogchar.render.app.entity.GoodyActionExtractor;
import org.cogchar.render.goody.basic.BasicGoodyCtx;
import org.cogchar.render.goody.basic.BasicGoodyEntity;
import org.cogchar.render.goody.basic.CompositeMeshBuilder;
import org.cogchar.render.sys.task.Queuer;

public class TG_TicTacMark
extends BasicGoodyEntity {
    private static final ColorRGBA X_COLOR = ColorRGBA.Black;
    private static final ColorRGBA O_COLOR = ColorRGBA.Red;
    private boolean playerO = false;
    private int indexX;
    private int indexO;

    public TG_TicTacMark(BasicGoodyCtx bgc, Ident boxUri, Vector3f initialPosition, Quaternion initialRotation, Vector3f size, boolean isPlayerO) {
        super(bgc, boxUri);
        Queuer.QueueingStyle qStyle = Queuer.QueueingStyle.QUEUE_AND_RETURN;
        this.setPositionAndRotation(initialPosition, initialRotation, qStyle);
        this.setVectorScale(size, qStyle);
        Mesh meshX = this.makeCustomXMesh();
        Torus meshO = new Torus(40, 20, 0.2f, 0.8333333f);
        float[] xRotationAngles = new float[]{1.5707964f, 0.0f, 0.0f};
        this.indexO = this.addGeometry((Mesh)meshO, O_COLOR);
        this.indexX = this.addGeometry(meshX, X_COLOR, new Quaternion(xRotationAngles));
        this.playerO = isPlayerO;
    }

    private Mesh makeCustomXMesh() {
        CompositeMeshBuilder builder = new CompositeMeshBuilder();
        Cylinder meshXLeg = new Cylinder(20, 20, 0.2f, 2.25f, true);
        Quaternion rotate45DegAroundY = new Quaternion();
        rotate45DegAroundY.fromAngleAxis(0.7853982f, new Vector3f(0.0f, 1.0f, 0.0f));
        ArrayList<CompositeMeshBuilder.MeshComponent> meshComponents = new ArrayList<CompositeMeshBuilder.MeshComponent>();
        meshComponents.add(new CompositeMeshBuilder.MeshComponent((Mesh)meshXLeg, rotate45DegAroundY));
        meshComponents.add(new CompositeMeshBuilder.MeshComponent((Mesh)meshXLeg, rotate45DegAroundY.inverse()));
        return builder.makeCompositeMesh(meshComponents);
    }

    public void attachToVirtualWorldNode(Node rootNode, Queuer.QueueingStyle qStyle) {
        this.attachToVirtualWorldNode(rootNode, this.playerO ? this.indexO : this.indexX, qStyle);
    }

    public void attachToVirtualWorldNode(Node rootNode, boolean isAnO, Queuer.QueueingStyle qStyle) {
        this.playerO = isAnO;
        this.attachToVirtualWorldNode(rootNode, qStyle);
    }

    public void setAsX(Queuer.QueueingStyle qStyle) {
        this.setState(false, qStyle);
    }

    public void setAsO(Queuer.QueueingStyle qStyle) {
        this.setState(true, qStyle);
    }

    private void setState(boolean isAnO, Queuer.QueueingStyle qStyle) {
        int geometryIndex = isAnO ? this.indexO : this.indexX;
        this.setGeometryByIndex(geometryIndex, qStyle);
        this.playerO = isAnO;
    }

    public void applyAction(GoodyActionExtractor ga, Queuer.QueueingStyle qStyle) {
        switch (ga.getKind()) {
            case SET: {
                String stateString = ga.getSpecialString(GoodyNames.USE_O);
                if (stateString == null) break;
                try {
                    this.setState(Boolean.valueOf(stateString), qStyle);
                }
                catch (Exception e) {
                    this.getLogger().error("The TicTacMark {} parameter must be either \"true\" or \"false\"; observed value is {}", (Object)new Object[]{GoodyNames.USE_O.getLocalName(), stateString}, (Object)e);
                }
                break;
            }
            default: {
                super.applyAction(ga, qStyle);
            }
        }
    }
}

