/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.visual.shallow;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import org.cogchar.bind.symja.MathGate;
import org.friendularity.visual.shallow.VisualMathExprLib;

public class VisualItemBase {
    private VisualMathExprLib.Vec3fExprNode myPosExprNode;
    private VisualMathExprLib.ColorExprNode myColorExprNode;
    private VisualMathExprLib.QuaternionExprNode myDirectionExprNode;

    public void setPosMathExpr(String mathExpr) {
        if (this.myPosExprNode == null) {
            this.myPosExprNode = new VisualMathExprLib.Vec3fExprNode(mathExpr);
        } else {
            this.myPosExprNode.setMathExpr(mathExpr);
        }
    }

    public void setColorMathExpr(String mathExpr) {
        if (this.myColorExprNode == null) {
            this.myColorExprNode = new VisualMathExprLib.ColorExprNode(mathExpr);
        } else {
            this.myColorExprNode.setMathExpr(mathExpr);
        }
    }

    public void setDirectionMathExpr(String mathExpr) {
        if (this.myDirectionExprNode == null) {
            this.myDirectionExprNode = new VisualMathExprLib.QuaternionExprNode(mathExpr);
        } else {
            this.myDirectionExprNode.setMathExpr(mathExpr);
        }
    }

    public Vector3f getVisualPos() {
        if (this.myPosExprNode != null) {
            Vector3f posVec = this.myPosExprNode.getVector3f();
            return posVec;
        }
        return null;
    }

    public ColorRGBA getVisualColor() {
        if (this.myColorExprNode != null) {
            ColorRGBA color = this.myColorExprNode.getColor();
            return color;
        }
        return null;
    }

    public Quaternion getVisualDirection() {
        if (this.myDirectionExprNode != null) {
            Quaternion dirQuat = (Quaternion)this.myDirectionExprNode.getOutputObject();
            return dirQuat;
        }
        return null;
    }

    public void updateFromMathSpace(MathGate mg) {
        if (this.myPosExprNode != null) {
            this.myPosExprNode.doUpdate(mg);
        }
        if (this.myColorExprNode != null) {
            this.myColorExprNode.doUpdate(mg);
        }
        if (this.myDirectionExprNode != null) {
            this.myDirectionExprNode.doUpdate(mg);
        }
    }

    public void useTestPatternExprs() {
        String selfPosVecExpr = "{5.0^Sin[$phaseAng], 6.0^(2*Cos[$phaseAng]), $phaseFrac}";
    }
}

