/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.visual.texture;

import com.jme3.texture.Image;
import com.jme3.texture.Texture2D;
import com.jme3.texture.plugins.AWTLoader;
import java.awt.image.BufferedImage;
import org.appdapter.core.log.BasicDebugger;
import org.friendularity.jvision.broker.ImageFlavorNotAvailable;
import org.friendularity.jvision.broker.ImageStreamBroker;
import org.friendularity.jvision.broker.ImageStreamConsumer;
import org.friendularity.jvision.broker.ImageStreamImage;
import org.slf4j.LoggerFactory;

public class JVisionTextureMapper
extends BasicDebugger
implements ImageStreamConsumer {
    Texture2D myLatestTexture;

    public void connectToImageStreamBroker() {
        this.getLogger().info("Making blocking connection to JVision using waitAndAddImageStreamConsumer()");
        ImageStreamBroker.getDefaultImageStreamBroker().waitAndAddImageStreamConsumer("jvision.camera", (ImageStreamConsumer)this);
    }

    private Texture2D loadTextureFromImage(BufferedImage buffdImg) {
        AWTLoader awtLoader = new AWTLoader();
        boolean flag_flipY = false;
        Image awtImage = awtLoader.load(buffdImg, flag_flipY);
        Texture2D cameraTex = new Texture2D(awtImage);
        return cameraTex;
    }

    public void setConsumedImage(ImageStreamImage visionBuffdImg) {
        try {
            this.myLatestTexture = this.loadTextureFromImage(visionBuffdImg.getBufferedImage());
        }
        catch (ImageFlavorNotAvailable ex) {
            LoggerFactory.getLogger((String)JVisionTextureMapper.class.getName()).info("JVisionTextureMapper fed with stream not convertable to BufferedImage", (Throwable)ex);
        }
    }

    public Texture2D peekLatestTexture() {
        return this.myLatestTexture;
    }

    public Texture2D takeLatestTextureOrNull() {
        Texture2D taken = this.myLatestTexture;
        this.myLatestTexture = null;
        return taken;
    }

    public void setConsumedMessage(String string) {
    }

    public void sourceIsEnding() {
    }
}

