/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.visual.texture;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import org.appdapter.core.log.BasicDebugger;
import org.cogchar.render.opengl.scene.DeepSceneMgr;
import org.cogchar.render.sys.registry.RenderRegistryClient;
import org.friendularity.visual.texture.JVisionTextureMapper;
import org.friendularity.visual.texture.OffscreenTextureMapper;

public class MagicVisionBoxScene
extends BasicDebugger {
    private Geometry myOnscreenBoxGeom;
    private OffscreenTextureMapper myOTM;
    private JVisionTextureMapper myJVTM;

    public void setup_onRendThrd(RenderRegistryClient rrc, float tpf) {
        AssetManager assetMgr = rrc.getJme3AssetManager(null);
        RenderManager renderMgr = rrc.getJme3RenderManager(null);
        this.myOTM = new OffscreenTextureMapper();
        Texture txtr = this.myOTM.setupOffscreenView_onRendThrd(renderMgr, assetMgr, tpf);
        this.myOnscreenBoxGeom = this.makeOnscreenTexturedBox(txtr, assetMgr);
        DeepSceneMgr dsm = rrc.getSceneDeepFacade(null);
        dsm.attachTopSpatial((Spatial)this.myOnscreenBoxGeom);
        this.getLogger().info("Attached onscreen box, offview enabled=" + this.myOTM.isEnabled());
    }

    public void setJVisionTextureMapper(JVisionTextureMapper jvtm) {
        this.myJVTM = jvtm;
    }

    public Geometry makeOnscreenTexturedBox(Texture tex, AssetManager assetMgr) {
        Geometry boxGeom = new Geometry("boxOn", (Mesh)new Box(Vector3f.ZERO, 20.0f, 20.0f, 20.0f));
        Material mat = new Material(assetMgr, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setTexture("ColorMap", tex);
        boxGeom.setMaterial(mat);
        return boxGeom;
    }

    public void update_onRendThrd(float tpf) {
        Texture2D latestTexture;
        if (this.myJVTM != null && (latestTexture = this.myJVTM.takeLatestTextureOrNull()) != null) {
            this.myOTM.writeTextureToOffscreenBoxMaterial_onRendThrd(latestTexture);
        }
        this.myOTM.updateRotatingOffscreenBox_onRendThrd(tpf);
    }
}

