/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.visual.texture;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;

public class OffscreenTextureMapper {
    private ViewPort myOffscrenViewport;
    private Material myOffscreenBoxMaterial = new Material();
    private Geometry myOffscreenBoxGeom;
    private float myOffscreenBoxRotationAngle = 0.0f;

    public Texture setupOffscreenView_onRendThrd(RenderManager renderMgr, AssetManager assetMgr, float tpf) {
        Camera offCamera = new Camera(512, 512);
        this.myOffscrenViewport = renderMgr.createPreView("Offscreen View", offCamera);
        this.myOffscrenViewport.setClearFlags(true, true, true);
        this.myOffscrenViewport.setBackgroundColor(ColorRGBA.DarkGray);
        FrameBuffer offBuffer = new FrameBuffer(512, 512, 1);
        offCamera.setFrustumPerspective(45.0f, 1.0f, 1.0f, 1000.0f);
        offCamera.setLocation(new Vector3f(0.0f, 0.0f, -5.0f));
        offCamera.lookAt(new Vector3f(0.0f, 0.0f, 0.0f), Vector3f.UNIT_Y);
        Texture2D offTex = new Texture2D(512, 512, Image.Format.RGBA8);
        offTex.setMinFilter(Texture.MinFilter.Trilinear);
        offTex.setMagFilter(Texture.MagFilter.Bilinear);
        offBuffer.setDepthBuffer(Image.Format.Depth);
        offBuffer.setColorTexture(offTex);
        this.myOffscrenViewport.setOutputFrameBuffer(offBuffer);
        Box boxMesh = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
        Material material = assetMgr.loadMaterial("jme3dat/Interface/Logo/Logo.j3m");
        this.myOffscreenBoxMaterial = material.clone();
        this.myOffscreenBoxGeom = new Geometry("boxOff", (Mesh)boxMesh);
        this.myOffscreenBoxGeom.setMaterial(this.myOffscreenBoxMaterial);
        this.myOffscrenViewport.attachScene((Spatial)this.myOffscreenBoxGeom);
        this.myOffscreenBoxGeom.updateLogicalState(tpf);
        this.myOffscreenBoxGeom.updateGeometricState();
        return offTex;
    }

    public boolean isEnabled() {
        if (this.myOffscrenViewport != null) {
            return this.myOffscrenViewport.isEnabled();
        }
        return false;
    }

    public void updateRotatingOffscreenBox_onRendThrd(float tpf) {
        Quaternion q = new Quaternion();
        if (this.myOffscrenViewport.isEnabled()) {
            this.myOffscreenBoxRotationAngle += tpf;
            this.myOffscreenBoxRotationAngle %= (float)Math.PI * 2;
            q.fromAngles(this.myOffscreenBoxRotationAngle, 0.0f, this.myOffscreenBoxRotationAngle);
            this.myOffscreenBoxGeom.setLocalRotation(q);
            this.myOffscreenBoxGeom.updateLogicalState(tpf);
            this.myOffscreenBoxGeom.updateGeometricState();
        }
    }

    public void writeTextureToOffscreenBoxMaterial_onRendThrd(Texture2D cameraTex) {
        this.myOffscreenBoxMaterial.setTexture("ColorMap", (Texture)cameraTex);
        this.myOffscreenBoxGeom.setMaterial(this.myOffscreenBoxMaterial);
    }
}

