/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.vsim.vworld;

import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import org.cogchar.bind.midi.in.CCParamRouter;
import org.cogchar.bind.midi.in.ParamValueListener;
import org.cogchar.render.sys.registry.RenderRegistryClient;
import org.cogchar.render.trial.MathUtils;
import org.cogchar.render.trial.TrialContent;
import org.friendularity.struct.Factory;
import org.friendularity.struct.OtherRingBuf;
import org.friendularity.visual.texture.JVisionTextureMapper;

public class SnapshotMonitor
extends TrialContent
implements ParamValueListener {
    private JVisionTextureMapper myJVTM;
    private Mode myMode = Mode.FIXED_POS;
    private float myCursorAz = 0.0f;
    private float myCursorEl;
    private float myCursorTwist;
    private float myCursorDist = 15.0f;
    private Vector3f myBaseVec;
    private OtherRingBuf<PanelItem> myIRB;
    private Node mySnapRootNode;
    private Geometry myCursorGeom;

    public void setup_onRendThrd(RenderRegistryClient rrc, Node parentNode) {
        this.mySnapRootNode = new Node("snapshot_monitor_root");
        this.myBaseVec = new Vector3f(5.0f, 10.0f, 5.0f);
        Material baseMat = SnapshotMonitor.makeAlphaBlendedUnshadedMaterial((RenderRegistryClient)rrc, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int panelCount = 10;
        ItemFactory anItemFactory = new ItemFactory();
        int panelWidth = 32;
        int panelHeight = 24;
        this.myCursorGeom = new Geometry("snapshot_cursor", (Mesh)new Quad((float)panelWidth, (float)panelHeight));
        Material cursorMat = baseMat.clone();
        ColorRGBA cursorColor = new ColorRGBA(0.8f, 0.2f, 0.8f, 0.5f);
        cursorMat.setColor("Color", cursorColor);
        this.myCursorGeom.setMaterial(cursorMat);
        this.mySnapRootNode.attachChild((Spatial)this.myCursorGeom);
        this.myIRB = new OtherRingBuf<PanelItem>(panelCount, anItemFactory);
        for (int panelIndex = 0; panelIndex < panelCount; ++panelIndex) {
            PanelItem panelItem = this.myIRB.getCurrent();
            panelItem.myAbsIndex = panelIndex;
            this.myIRB.advance();
            Geometry qg = new Geometry("snapshot_pvq_" + panelIndex, (Mesh)new Quad((float)panelWidth, (float)panelHeight));
            Material panelMat = baseMat.clone();
            qg.setMaterial(panelMat);
            SnapshotMonitor.configureRenderingForSpatial((Spatial)qg);
            Vector3f offsetV = this.calculateDefaultPosition(panelIndex);
            qg.setLocalTranslation(offsetV);
            this.mySnapRootNode.attachChild((Spatial)qg);
            panelItem.myMat = panelMat;
            panelItem.myGeom = qg;
        }
        this.mySnapRootNode.setLocalTranslation(this.myBaseVec);
        parentNode.attachChild((Spatial)this.mySnapRootNode);
    }

    private Vector3f calculateDefaultPosition(int panelIndex) {
        float d = (float)panelIndex * 25.0f;
        Vector3f offsetV = new Vector3f(-0.8f * d, -20.0f + 0.5f * d, -3.0f - 1.0f * d);
        return offsetV;
    }

    public void setJVisionTextureMapper(JVisionTextureMapper jvtm) {
        this.myJVTM = jvtm;
    }

    public void setMode(Mode m) {
        this.myMode = m;
    }

    public void update_onRendThrd(float tpf) {
        this.updateCursorPos_onRendThread(tpf);
        PanelItem panelItem = this.myIRB.getCurrent();
        if (this.myJVTM != null) {
            Texture2D latestTexture = this.myJVTM.peekLatestTexture();
            if (latestTexture != null) {
                panelItem.myTexture = latestTexture;
                panelItem.myMat.setTexture("ColorMap", (Texture)panelItem.myTexture);
                panelItem.myGeom.setMaterial(panelItem.myMat);
                if (this.myMode == Mode.FOLLOW_CURSOR) {
                    Vector3f cursPos = this.myCursorGeom.getLocalTranslation();
                    Quaternion cursRot = this.myCursorGeom.getLocalRotation();
                    panelItem.myGeom.setLocalTranslation(cursPos);
                    panelItem.myGeom.setLocalRotation(cursRot);
                } else {
                    Vector3f offsetV = this.calculateDefaultPosition(panelItem.myAbsIndex);
                    panelItem.myGeom.setLocalTranslation(offsetV);
                }
                this.adjustOpacities_onRendThread();
                this.myIRB.advance();
            }
        } else {
            float colorPhase = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
            ColorRGBA color = new ColorRGBA(colorPhase, 0.3f, 0.0f, 0.5f);
            panelItem.myMat.setColor("Color", color);
            panelItem.myGeom.setMaterial(panelItem.myMat);
            this.adjustOpacities_onRendThread();
            this.myIRB.advance();
        }
    }

    private void adjustOpacities_onRendThread() {
        int panelCount = this.myIRB.mySize();
        for (int howFarBack = 0; howFarBack < panelCount; ++howFarBack) {
            PanelItem prevItem = this.myIRB.getPrevious(howFarBack);
            prevItem.myAlphaOpacity = (float)(panelCount - howFarBack) / (1.0f * (float)panelCount);
            float oldRed = prevItem.myColor.getRed();
            float oldGreen = prevItem.myColor.getGreen();
            float oldBlue = prevItem.myColor.getBlue();
            prevItem.myColor.set(oldRed, oldGreen, oldBlue, prevItem.myAlphaOpacity);
            prevItem.myMat.setColor("Color", prevItem.myColor);
            prevItem.myGeom.setMaterial(prevItem.myMat);
        }
    }

    private void updateCursorPos_onRendThread(float tpf) {
        float[] eulerAngles = new float[]{this.myCursorEl, this.myCursorAz, this.myCursorTwist};
        Quaternion quat = new Quaternion(eulerAngles);
        Vector3f base = Vector3f.UNIT_Z;
        Vector3f rotated = quat.mult(base);
        Vector3f cpos = rotated.mult(this.myCursorDist);
        this.myCursorGeom.setLocalTranslation(cpos);
        this.myCursorGeom.setLocalRotation(quat);
    }

    public void attachMidiCCs(CCParamRouter ccpr) {
        ccpr.putControlChangeParamBinding(27, Coord.AZIMUTH.name(), (ParamValueListener)this);
        ccpr.putControlChangeParamBinding(28, Coord.ELEVATION.name(), (ParamValueListener)this);
        ccpr.putControlChangeParamBinding(26, Coord.TWIST.name(), (ParamValueListener)this);
        ccpr.putControlChangeParamBinding(40, Coord.DEPTH.name(), (ParamValueListener)this);
        ccpr.putControlChangeParamBinding(25, Coord.DEPTH.name(), (ParamValueListener)this);
        ccpr.putControlChangeParamBinding(58, Coord.MODE.name(), (ParamValueListener)this);
    }

    public void setNormalizedNumericParam(String paramName, float normZeroToOne) {
        Coord ccoord = Coord.valueOf(paramName);
        float halfPi = 1.5707964f;
        switch (ccoord) {
            case AZIMUTH: {
                this.myCursorAz = MathUtils.getFloatValInRange((float)(-1.0f * halfPi), (float)halfPi, (float)normZeroToOne);
                break;
            }
            case ELEVATION: {
                this.myCursorEl = MathUtils.getFloatValInRange((float)(-1.0f * halfPi), (float)halfPi, (float)normZeroToOne);
                break;
            }
            case TWIST: {
                this.myCursorTwist = MathUtils.getFloatValInRange((float)(-1.0f * halfPi), (float)halfPi, (float)normZeroToOne);
                break;
            }
            case DEPTH: {
                this.myCursorDist = MathUtils.getFloatValInRange((float)-50.0f, (float)50.0f, (float)normZeroToOne);
                break;
            }
            case MODE: {
                if ((double)normZeroToOne > 0.5) {
                    this.myMode = Mode.FOLLOW_CURSOR;
                    break;
                }
                this.myMode = Mode.FIXED_POS;
                break;
            }
            default: {
                this.getLogger().warn("Unknown numeric-param channel name: {} resolved to: {}", (Object)paramName, (Object)ccoord);
            }
        }
    }

    static enum Coord {
        AZIMUTH,
        ELEVATION,
        TWIST,
        DEPTH,
        MODE;

    }

    public static class ItemFactory
    extends Factory<PanelItem> {
        public PanelItem[] makeArray(int size) {
            return new PanelItem[size];
        }

        @Override
        public PanelItem makeOne() {
            return new PanelItem();
        }

        @Override
        public void shallowCopyContents(PanelItem source, PanelItem target) {
            target.myTexture = source.myTexture;
        }
    }

    public static class PanelItem {
        Texture2D myTexture;
        Material myMat;
        Geometry myGeom;
        float myAlphaOpacity = 0.5f;
        ColorRGBA myColor = new ColorRGBA(1.0f, 1.0f, 1.0f, this.myAlphaOpacity);
        int myAbsIndex;
    }

    static enum Mode {
        FIXED_POS,
        FOLLOW_CURSOR;

    }
}

