/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.vsim.vworld;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URISyntaxException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQTopic;
import org.appdapter.core.log.BasicDebugger;
import org.jflux.api.common.rk.utils.TimeUtils;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.Listener;
import org.jflux.api.core.util.EmptyAdapter;
import org.jflux.api.messaging.rk.MessageAsyncReceiver;
import org.jflux.api.messaging.rk.MessageSender;
import org.jflux.api.messaging.rk.services.ServiceCommandFactory;
import org.jflux.impl.messaging.rk.JMSAvroMessageAsyncReceiver;
import org.jflux.impl.messaging.rk.JMSAvroMessageSender;
import org.jflux.impl.messaging.rk.ServiceErrorRecord;
import org.jflux.impl.messaging.rk.services.PortableServiceCommand;
import org.jflux.impl.messaging.rk.utils.ConnectionUtils;
import org.mechio.api.vision.ImageEvent;
import org.mechio.api.vision.ImageRegion;
import org.mechio.api.vision.ImageRegionList;
import org.mechio.api.vision.config.CameraServiceConfig;
import org.mechio.api.vision.config.FaceDetectServiceConfig;
import org.mechio.api.vision.messaging.RemoteImageRegionServiceClient;
import org.mechio.api.vision.messaging.RemoteImageServiceClient;
import org.mechio.impl.vision.ImageRecord;
import org.mechio.impl.vision.ImageRegionListRecord;
import org.mechio.impl.vision.PortableImageUtils;

public class UnusedNetworkVisionDataFeed
extends BasicDebugger {
    private RemoteImageServiceClient myVideoService;
    private RemoteImageRegionServiceClient myFaceService;
    private Image myImage;
    private ImageRegionList<ImageRegion> myImageRegions;
    private Runnable myRepaint;
    private ImageCache myImageCache;
    private ImageRegionListCache myImageRegionListCache;

    public boolean connectServices() {
        String brokerTCP_Addr = "127.0.0.1:5672";
        String brokerAMQP_URL = "amqp://" + ConnectionUtils.getUsername() + ":" + ConnectionUtils.getPassword() + "@clientid/test?brokerlist='tcp://" + brokerTCP_Addr + "'";
        try {
            this.myVideoService = this.connectToVisionImgSvc(brokerAMQP_URL);
            this.myFaceService = this.connectToVisionRegionSvc(brokerAMQP_URL);
            if (this.myVideoService != null && this.myFaceService != null) {
                return true;
            }
        }
        catch (Throwable t) {
            this.getLogger().error("Cannot connect to *AMQP* vision streams - but this error does not affect JVision", t);
            t.printStackTrace();
        }
        return false;
    }

    public void registerDummyListeners() {
        this.myImageCache = new ImageCache();
        this.myImageRegionListCache = new ImageRegionListCache();
        this.myVideoService.addImageListener((Listener)this.myImageCache);
        this.myFaceService.addImageRegionsListener((Listener)this.myImageRegionListCache);
    }

    public void startServices() {
        this.myVideoService.start(TimeUtils.now());
        this.myFaceService.start(TimeUtils.now());
    }

    private RemoteImageServiceClient connectToVisionImgSvc(String brokerAMQP_URL) throws URISyntaxException, JMSException, Exception {
        AMQConnectionFactory cf = new AMQConnectionFactory(brokerAMQP_URL);
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 2);
        connection.start();
        AMQQueue cmdDest = new AMQQueue("camera0Command; {create: always, node: {type: queue}}");
        AMQTopic errDest = new AMQTopic("camera0Error; {create: always, node: {type: topic}}");
        AMQTopic imgDest = new AMQTopic("camera0Event; {create: always, node: {type: topic}}");
        JMSAvroMessageSender cmdSender = new JMSAvroMessageSender(session, (Destination)cmdDest);
        JMSAvroMessageSender configSender = new JMSAvroMessageSender(session, (Destination)cmdDest);
        JMSAvroMessageAsyncReceiver errorReceiver = new JMSAvroMessageAsyncReceiver(session, (Destination)errDest, ServiceErrorRecord.class, ServiceErrorRecord.SCHEMA$);
        PortableServiceCommand.Factory cmdFactory = new PortableServiceCommand.Factory();
        JMSAvroMessageAsyncReceiver imageReceiver = new JMSAvroMessageAsyncReceiver(session, (Destination)imgDest, ImageRecord.class, ImageRecord.SCHEMA$);
        RemoteImageServiceClient service = new RemoteImageServiceClient(CameraServiceConfig.class, "imageService", "remoteId", (MessageSender)cmdSender, (MessageSender)configSender, (MessageAsyncReceiver)errorReceiver, (ServiceCommandFactory)cmdFactory, (MessageAsyncReceiver)imageReceiver);
        cmdSender.setAdapter((Adapter)new EmptyAdapter());
        cmdSender.setDefaultContentType("application/service-command");
        cmdSender.start();
        errorReceiver.setAdapter((Adapter)new EmptyAdapter());
        errorReceiver.start();
        imageReceiver.setAdapter((Adapter)new EmptyAdapter());
        imageReceiver.start();
        return service;
    }

    private RemoteImageRegionServiceClient connectToVisionRegionSvc(String brokerAMQP_URL) throws URISyntaxException, JMSException, Exception {
        AMQConnectionFactory cf = new AMQConnectionFactory(brokerAMQP_URL);
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 2);
        connection.start();
        AMQQueue cmdDest = new AMQQueue("visionproc0Command; {create: always, node: {type: queue}}");
        AMQTopic errDest = new AMQTopic("visionproc0Error; {create: always, node: {type: topic}}");
        AMQTopic imgRgnDest = new AMQTopic("visionproc0Event; {create: always, node: {type: topic}}");
        JMSAvroMessageSender cmdSender = new JMSAvroMessageSender(session, (Destination)cmdDest);
        JMSAvroMessageSender configSender = new JMSAvroMessageSender(session, (Destination)cmdDest);
        JMSAvroMessageAsyncReceiver errorReceiver = new JMSAvroMessageAsyncReceiver(session, (Destination)errDest, ServiceErrorRecord.class, ServiceErrorRecord.SCHEMA$);
        PortableServiceCommand.Factory cmdFactory = new PortableServiceCommand.Factory();
        JMSAvroMessageAsyncReceiver imageRgnReceiver = new JMSAvroMessageAsyncReceiver(session, (Destination)imgRgnDest, ImageRegionListRecord.class, ImageRegionListRecord.SCHEMA$);
        RemoteImageRegionServiceClient service = new RemoteImageRegionServiceClient(FaceDetectServiceConfig.class, "imageService", "remoteId", (MessageSender)cmdSender, (MessageSender)configSender, (MessageAsyncReceiver)errorReceiver, (ServiceCommandFactory)cmdFactory, (MessageAsyncReceiver)imageRgnReceiver);
        cmdSender.setAdapter((Adapter)new EmptyAdapter());
        cmdSender.setDefaultContentType("application/service-command");
        cmdSender.start();
        errorReceiver.setAdapter((Adapter)new EmptyAdapter());
        errorReceiver.start();
        imageRgnReceiver.setAdapter((Adapter)new EmptyAdapter());
        imageRgnReceiver.start();
        return service;
    }

    class ImageRegionListCache
    implements Listener<ImageRegionList> {
        int myEventCounter;

        ImageRegionListCache() {
        }

        public void handleEvent(ImageRegionList event) {
            if (event == null) {
                return;
            }
            UnusedNetworkVisionDataFeed.this.myImageRegions = event;
            if (this.myEventCounter % 100 == 0) {
                UnusedNetworkVisionDataFeed.this.getLogger().info("Received imageRegions event #" + this.myEventCounter);
            }
            ++this.myEventCounter;
        }
    }

    class ImageCache
    implements Listener<ImageEvent> {
        int myEventCounter;

        ImageCache() {
        }

        public void handleEvent(ImageEvent event) {
            if (event == null) {
                return;
            }
            BufferedImage img = PortableImageUtils.unpackImage((ImageEvent)event);
            if (img == null) {
                return;
            }
            UnusedNetworkVisionDataFeed.this.myImage = img;
            if (this.myEventCounter % 100 == 0) {
                UnusedNetworkVisionDataFeed.this.getLogger().info("Received image event #" + this.myEventCounter);
            }
            ++this.myEventCounter;
        }
    }
}

