/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.vw.cli.cam;

import org.appdapter.core.name.Ident;
import org.friendularity.infra.cpmsg.CPMsgTeller;
import org.friendularity.infra.cpmsg.CPStrongTeller;
import org.friendularity.infra.cpmsg.CPumpMsg;
import org.friendularity.vw.cli.cam.OuterCamHelp;
import org.friendularity.vw.mprt.manip.CamState3D;
import org.friendularity.vw.mprt.manip.ManipCompletionHandle;
import org.friendularity.vw.mprt.manip.ManipDesc;
import org.friendularity.vw.mprt.manip.ManipStatusMsg;
import org.friendularity.vw.mprt.manip.MaybeTransform3D;
import org.friendularity.vw.msg.shp.deep.ShapeManipRqImpl;
import org.friendularity.vw.msg.shp.deep.VWSCR_CamGuideNode;
import org.friendularity.vw.msg.shp.deep.VWSCR_Node;
import org.friendularity.vw.msg.stg.VWBindCamNodeRq;
import org.friendularity.vw.msg.stg.VWCreateCamAndViewportRq;
import org.friendularity.vw.msg.stg.VWModifyCamStateRq;
import org.friendularity.vw.msg.stg.ViewportDesc;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;

public abstract class OuterCamHelp$class {
    public static Ident makeAndBindExtraCam(OuterCamHelp $this, CPMsgTeller stageTeller, CPMsgTeller spcTeller, String camShortLabel, CamState3D initCamState, ViewportDesc initVP) {
        Ident camID = $this.makeStampyRandyIdent(new StringBuilder().append((Object)camShortLabel).append((Object)"_intrnCam").toString());
        Ident camGuideNodeID = $this.makeStampyRandyIdent(new StringBuilder().append((Object)camShortLabel).append((Object)"_camGuide").toString());
        $this.makeAndBindExtraCam(stageTeller, spcTeller, camID, camGuideNodeID, initCamState, initVP);
        return camGuideNodeID;
    }

    public static void makeAndBindExtraCam(OuterCamHelp $this, CPMsgTeller stageTeller, CPMsgTeller spcTeller, Ident camID, Ident camGuideNodeID, CamState3D initCamState, ViewportDesc initVP) {
        $this.info1("Requesting cam at ID={}", camID);
        VWCreateCamAndViewportRq makeCamRq = new VWCreateCamAndViewportRq(camID, initCamState, initVP);
        stageTeller.tellCPMsg((CPumpMsg)makeCamRq);
        $this.info1("Requesting cam(xtra)-guide node at ID={}", camGuideNodeID);
        VWSCR_Node makeGuideNodeRQ = new VWSCR_Node(camGuideNodeID, (Option<Ident>)None$.MODULE$);
        spcTeller.tellCPMsg((CPumpMsg)makeGuideNodeRQ);
        boolean flag_guideIsParent = true;
        $this.info2("Binding xtra cam at ID={} to cam-guide node at ID={}", camID, camGuideNodeID);
        boolean flag_attachVisibleMarker = true;
        VWBindCamNodeRq camGuideBindRq = new VWBindCamNodeRq(camID, flag_guideIsParent, spcTeller, camGuideNodeID, flag_attachVisibleMarker);
        stageTeller.tellCPMsg((CPumpMsg)camGuideBindRq);
    }

    public static void bindKnownCam(OuterCamHelp $this, CPMsgTeller stageTeller, CPMsgTeller spcTeller, Ident camID, Ident camGuideNodeID, boolean flag_attachVisibleMarker) {
        $this.info1("Requesting cam(known)-guide node at ID={}", camGuideNodeID);
        VWSCR_CamGuideNode makeGuideNodeRQ = new VWSCR_CamGuideNode(camGuideNodeID, (Option<Ident>)None$.MODULE$);
        spcTeller.tellCPMsg((CPumpMsg)makeGuideNodeRQ);
        boolean flag_guideIsParent = true;
        $this.info2("Binding known cam at ID={} to cam-guide node at ID={}", camID, camGuideNodeID);
        VWBindCamNodeRq camGuideBindRq = new VWBindCamNodeRq(camID, flag_guideIsParent, spcTeller, camGuideNodeID, flag_attachVisibleMarker);
        stageTeller.tellCPMsg((CPumpMsg)camGuideBindRq);
    }

    public static Option sendGuidedCamMoveRq(OuterCamHelp $this, CPMsgTeller spcTeller, Ident xtraCamGuideNodeID, MaybeTransform3D mayXform, Option durSec_opt, Option statusTlr_opt) {
        boolean forceToFullXform = false;
        ManipDesc manipGuts = $this.makeManipGuts(mayXform, (Option<Float>)durSec_opt, forceToFullXform);
        ShapeManipRqImpl guideManipMsg = new ShapeManipRqImpl(xtraCamGuideNodeID, manipGuts, (Option<CPStrongTeller<ManipStatusMsg>>)statusTlr_opt);
        Option statusHandlerID_opt = guideManipMsg.getStatusHandler_opt().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Ident apply(ManipCompletionHandle x$1) {
                return x$1.getHandleID();
            }
        });
        $this.info2("Sending guided cam manip msg with statusHandlerID_opt={} to spcTeller: {}", statusHandlerID_opt, guideManipMsg);
        spcTeller.tellCPMsg((CPumpMsg)guideManipMsg);
        return statusHandlerID_opt;
    }

    public static void sendCamStateModifyRq(OuterCamHelp $this, CPMsgTeller stgTeller, Ident camID, Option updState_opt, Option updVP_opt) {
        VWModifyCamStateRq msg = new VWModifyCamStateRq(camID, (Option<CamState3D>)updState_opt, (Option<ViewportDesc>)updVP_opt);
        stgTeller.tellCPMsg((CPumpMsg)msg);
    }

    public static void $init$(OuterCamHelp $this) {
    }
}

