/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.vw.impl.stg;

import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.input.FlyByCamera;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;
import org.cogchar.render.app.core.WorkaroundAppStub;
import org.cogchar.render.sys.registry.RenderRegistryClient;
import org.friendularity.vw.impl.stg.BasicOpticsLogic;
import org.friendularity.vw.msg.stg.VWStageBackgroundColor;
import org.friendularity.vw.msg.stg.VWStageBackgroundSkybox;
import org.friendularity.vw.msg.stg.VWStageOpticsBasic;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;

public abstract class BasicOpticsLogic$class {
    public static void prepareIndependentOptics_onRendThrd(BasicOpticsLogic $this, WorkaroundAppStub workaroundStub, FlyByCamera flyCam, ViewPort mainViewPort, int moveSpeed, boolean pauseOnLostFocus, boolean dragMouseToRotateCamera) {
        $this.info1("prepareOpticsStage1: setting flyCam speed to {}", Predef$.MODULE$.int2Integer(moveSpeed));
        flyCam.setMoveSpeed((float)moveSpeed);
        flyCam.setDragToRotate(dragMouseToRotateCamera);
        workaroundStub.setPauseOnLostFocus(pauseOnLostFocus);
    }

    public static void setBackgroundColor_onRendThrd(BasicOpticsLogic $this, ViewPort mainViewPort, Node parentDeepNode, ColorRGBA bgColor) {
        $this.info1("prepareOpticsStage1: setting background color to {}", bgColor);
        if ($this.skyBox_opt().isDefined()) {
            $this.removeSkyBox_onRendThread(parentDeepNode);
        }
        mainViewPort.setBackgroundColor(bgColor);
    }

    public static void removeSkyBox_onRendThread(BasicOpticsLogic $this, Node parentDeepNode) {
        $this.info0("SkyBox is already set. Removing SkyBox.");
        parentDeepNode.detachChild((Spatial)$this.skyBox_opt().get());
        $this.skyBox_opt_$eq((Option<Spatial>)Option$.MODULE$.empty());
    }

    /*
     * WARNING - void declaration
     */
    public static Option mayLoadTexture_OnRenderThread(BasicOpticsLogic $this, AssetManager assetManager, String imagePath) {
        void var3_3;
        Option texture_opt = Option$.MODULE$.empty();
        try {
            texture_opt = Option$.MODULE$.apply((Object)assetManager.loadTexture(imagePath));
            if (texture_opt.isEmpty()) {
                $this.error1("Failed to load texture from: {}", imagePath);
            }
            $this.trace1("Successfully loaded texture from: {}", texture_opt);
        }
        catch (AssetNotFoundException assetNotFoundException) {
            $this.error1("Failed to load texture from: {}", imagePath);
        }
        return var3_3;
    }

    public static void setBackgroundSkyBox_onRendThrd(BasicOpticsLogic $this, Node parentDeepNode, AssetManager assetManager, String northImagePath, String eastImagePath, String southImagePath, String westImagePath, String upImagePath, String downImagePath) {
        $this.info3("Setting background skybox with the following images. [North: {}, East: {}, South: {}]", northImagePath, eastImagePath, southImagePath);
        $this.info3("Setting background skybox with the following images. [West: {}, Up: {}, Down: {}]", westImagePath, upImagePath, downImagePath);
        if ($this.skyBox_opt().isDefined()) {
            $this.removeSkyBox_onRendThread(parentDeepNode);
        }
        Option<Texture> northTexture = $this.mayLoadTexture_OnRenderThread(assetManager, northImagePath);
        Option<Texture> eastTexture = $this.mayLoadTexture_OnRenderThread(assetManager, eastImagePath);
        Option<Texture> southTexture = $this.mayLoadTexture_OnRenderThread(assetManager, southImagePath);
        Option<Texture> westTexture = $this.mayLoadTexture_OnRenderThread(assetManager, westImagePath);
        Option<Texture> upTexture = $this.mayLoadTexture_OnRenderThread(assetManager, upImagePath);
        Option<Texture> downTexture = $this.mayLoadTexture_OnRenderThread(assetManager, downImagePath);
        if (northTexture.isEmpty() || eastTexture.isEmpty() || southTexture.isEmpty() || westTexture.isEmpty() || upTexture.isEmpty() || downTexture.isEmpty()) {
            $this.error0("Tried to set SkyBox. Could not load all of the SkyBox's textures. Ensure paths to SkyBox texture images are correct.");
            return;
        }
        $this.skyBox_opt_$eq((Option<Spatial>)new Some((Object)SkyFactory.createSky((AssetManager)assetManager, (Texture)((Texture)westTexture.get()), (Texture)((Texture)eastTexture.get()), (Texture)((Texture)northTexture.get()), (Texture)((Texture)southTexture.get()), (Texture)((Texture)upTexture.get()), (Texture)((Texture)downTexture.get()))));
        parentDeepNode.attachChild((Spatial)$this.skyBox_opt().get());
    }

    public static void sendRendTaskForOpticsBasic(BasicOpticsLogic $this, VWStageOpticsBasic rq, RenderRegistryClient rrc) {
        WorkaroundAppStub workaroundStub = rrc.getWorkaroundAppStub();
        FlyByCamera fbCam = workaroundStub.getFlyByCamera();
        ViewPort mvp = workaroundStub.getPrimaryAppViewPort();
        Serializable senderCallable = new Serializable($this, workaroundStub, fbCam, mvp, rq){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicOpticsLogic $outer;
            private final WorkaroundAppStub workaroundStub$1;
            private final FlyByCamera fbCam$1;
            private final ViewPort mvp$1;
            private final VWStageOpticsBasic rq$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.prepareIndependentOptics_onRendThrd(this.workaroundStub$1, this.fbCam$1, this.mvp$1, this.rq$1.moveSpeed(), this.rq$1.pauseOnLostFocus(), this.rq$1.dragMouseToRotateCamera());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.workaroundStub$1 = workaroundStub$1;
                this.fbCam$1 = fbCam$1;
                this.mvp$1 = mvp$1;
                this.rq$1 = rq$1;
            }
        };
        $this.enqueueJmeCallable(rrc, (Function0)senderCallable);
    }

    public static void sendRendTaskForBackgroundSkyBox(BasicOpticsLogic $this, VWStageBackgroundSkybox rq, RenderRegistryClient rrc) {
        WorkaroundAppStub workaroundStub = rrc.getWorkaroundAppStub();
        ViewPort mvp = workaroundStub.getPrimaryAppViewPort();
        Node parentDeepNode = rrc.getJme3RootDeepNode(null);
        AssetManager assetManager = rrc.getJme3AssetManager(null);
        Serializable senderCallable = new Serializable($this, parentDeepNode, assetManager, rq){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicOpticsLogic $outer;
            private final Node parentDeepNode$1;
            private final AssetManager assetManager$1;
            private final VWStageBackgroundSkybox rq$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.setBackgroundSkyBox_onRendThrd(this.parentDeepNode$1, this.assetManager$1, this.rq$2.northImagePath(), this.rq$2.eastImagePath(), this.rq$2.southImagePath(), this.rq$2.westImagePath(), this.rq$2.upImagePath(), this.rq$2.downImagePath());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.parentDeepNode$1 = parentDeepNode$1;
                this.assetManager$1 = assetManager$1;
                this.rq$2 = rq$2;
            }
        };
        $this.enqueueJmeCallable(rrc, (Function0)senderCallable);
    }

    public static void sendRendTaskForBackgroundColor(BasicOpticsLogic $this, VWStageBackgroundColor rq, RenderRegistryClient rrc) {
        WorkaroundAppStub workaroundStub = rrc.getWorkaroundAppStub();
        ViewPort mvp = workaroundStub.getPrimaryAppViewPort();
        Node parentDeepNode = rrc.getJme3RootDeepNode(null);
        Serializable senderCallable = new Serializable($this, mvp, parentDeepNode, rq){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicOpticsLogic $outer;
            private final ViewPort mvp$2;
            private final Node parentDeepNode$2;
            private final VWStageBackgroundColor rq$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.setBackgroundColor_onRendThrd(this.mvp$2, this.parentDeepNode$2, this.rq$3.bgColor());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.mvp$2 = mvp$2;
                this.parentDeepNode$2 = parentDeepNode$2;
                this.rq$3 = rq$3;
            }
        };
        $this.enqueueJmeCallable(rrc, (Function0)senderCallable);
    }

    public static void $init$(BasicOpticsLogic $this) {
        $this.skyBox_opt_$eq((Option<Spatial>)Option$.MODULE$.empty());
        $this.backgroundColor_opt_$eq((Option<ColorRGBA>)Option$.MODULE$.empty());
    }
}

