/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.vwobstub;

import java.util.List;
import java.util.Map;
import org.cogchar.api.skeleton.config.BoneProjectionPosition;
import org.cogchar.api.skeleton.config.BoneRotationAxis;
import org.cogchar.bind.mio.robot.model.ModelRobot;
import org.cogchar.bind.mio.robot.model.ModelRobotUtils;
import org.cogchar.render.model.bony.BoneState;
import org.cogchar.render.model.bony.FigureState;
import org.cogchar.render.model.humanoid.HumanoidFigure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelToFigureStateMappingFuncs {
    static Logger theLogger = LoggerFactory.getLogger(ModelToFigureStateMappingFuncs.class);

    public static void propagateState(ModelRobot br, HumanoidFigure hf) {
        FigureState fs = hf.getFigureState();
        theLogger.trace("FigureState={}", (Object)fs);
        Map rotMap = ModelRobotUtils.getGoalAnglesAsRotations((ModelRobot)br);
        theLogger.trace("rotMap={}", (Object)rotMap);
        ModelToFigureStateMappingFuncs.applyAllSillyEulerRotations(fs, rotMap);
    }

    public static void applyAllSillyEulerRotations(FigureState fs, Map<String, List<BoneProjectionPosition>> rotMap) {
        for (Map.Entry<String, List<BoneProjectionPosition>> e : rotMap.entrySet()) {
            String boneName = e.getKey();
            BoneState bs = fs.getBoneState(boneName);
            if (bs == null) {
                theLogger.warn("Can't find boneState for {}", (Object)boneName);
                continue;
            }
            List<BoneProjectionPosition> rots = e.getValue();
            ModelToFigureStateMappingFuncs.applySillyEulerRotations(bs, rots);
        }
    }

    private static void applySillyEulerRotations(BoneState bs, List<BoneProjectionPosition> rots) {
        for (BoneProjectionPosition rot : rots) {
            BoneRotationAxis rotAxis = rot.getRotationAxis();
            float rads = (float)rot.getAngleRadians();
            switch (rotAxis) {
                case X_ROT: {
                    bs.rot_X_A3rd = rads;
                    break;
                }
                case Y_ROT: {
                    bs.rot_Y_A1st = rads;
                    break;
                }
                case Z_ROT: {
                    bs.rot_Z_A2nd = rads;
                }
            }
        }
    }
}

